/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.onlinepay.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.HmacArray;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.onlinepay.builder.OrderBuilder;
import com.upay.sdk.onlinepay.builder.QueryBuilder;
import com.upay.sdk.onlinepay.builder.RefundBuilder;
import com.upay.sdk.onlinepay.builder.SplitOrderBuilder;
import com.upay.sdk.onlinepay.builder.SplitQueryBuilder;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlinePayOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(OnlinePayOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS, "redirectUrl", Constants.SCANCODE, Constants.APPPARAMS, Constants.JSSTRING};
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "totalRefundCount", "totalRefundAmount", "orderCurrency", "orderAmount", Constants.STATUS, "completeDateTime", "remark", "bindCardId", HmacArray.create("subOrders", new String[]{Constants.REQUEST_ID, "orderAmount", Constants.SERIAL_NUMBER}), "usersSign"};
    static final String[] REFUND_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, "orderId", Constants.STATUS, "errorMessage", "amount", "currency", "completeDateTime"};

    public void order(JSONObject requestData, ResultListener resultListener) {
        block5: {
            try {
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                LOGGER.debug("subOrders is null:[" + requestData.get("subOrders") + "]");
                String responseStr = HttpClientUtils.post(ConfigurationUtils.getOnlinePayOrderUrl(), requestData.toJSONString());
                LOGGER.debug("responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS)) && StringUtils.isEmpty((CharSequence)responseData.getString(Constants.JSSTRING))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block5;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (StringUtils.isNotEmpty((CharSequence)responseData.getString(Constants.JSSTRING))) {
                    resultListener.success(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (IOException e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        String status = responseData.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(responseData);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(responseData);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(responseData);
            } else {
                throw new ResponseException(responseData);
            }
        }
    }

    public void query(JSONObject requestData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post(ConfigurationUtils.getOnlinePayQueryUrl(), requestData.toJSONString());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            this.callback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void refund(JSONObject requestData, ResultListener listener) {
        block6: {
            if (listener == null) {
                throw new NullPointerException();
            }
            try {
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post(ConfigurationUtils.getOnlinePayRefundUrl(), requestData.toJSONString());
                LOGGER.debug("responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                this.verifyHmac(REFUND_RESPONSE_HMAC_FIELDS, responseData);
                String status = responseData.getString(Constants.STATUS);
                if (Constants.SUCCESS.equals(status)) {
                    listener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    listener.failure(responseData);
                    break block6;
                }
                if (Constants.INIT.equals(status)) {
                    listener.pending(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void refundCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.verifyHmac(REFUND_RESPONSE_HMAC_FIELDS, responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void refundQuery(JSONObject requestData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post(ConfigurationUtils.getOnlinePayRefundQueryUrl(), requestData.toJSONString());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            this.refundCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void order(OrderBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.encryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post2(ConfigurationUtils.getOnlinePayOrderUrl(), requestData);
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.decryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.verifyHmacOrder(responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS)) && StringUtils.isEmpty((CharSequence)responseData.getString(Constants.JSSTRING))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block6;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (StringUtils.isNotEmpty((CharSequence)responseData.getString(Constants.JSSTRING))) {
                    resultListener.success(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void refund(RefundBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getOnlinePayRefundUrl(), builder.encryptBuild());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void query(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getOnlinePayQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.cipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void refundQuery(RefundBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getOnlinePayRefundQueryUrl(), builder.encryptBuild());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.cipherRefundCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void cipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void cipherRefundCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void bothOrder(OrderBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOnlinePayOrderUrl(), requestData);
                LOGGER.info("responseStr :{}", (Object)responseStr);
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.bothVerifyHmacOrder(responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS)) && StringUtils.isEmpty((CharSequence)responseData.getString(Constants.JSSTRING))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block6;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (StringUtils.isNotEmpty((CharSequence)responseData.getString(Constants.JSSTRING))) {
                    resultListener.success(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothRefund(RefundBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOnlinePayRefundUrl(), builder.bothEncryptBuild());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(responseData);
        status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void bothQuery(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOnlinePayQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothRefundQuery(RefundBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOnlinePayRefundQueryUrl(), builder.bothEncryptBuild());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.bothCipherRefundCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        LOGGER.info("status:{}", (Object)status);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void bothCipherRefundCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void bothSplitOrder(SplitOrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("bothSplitOrder requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOnlinePaySplitOrderUrl(), requestData);
            LOGGER.info("bothSplitOrder responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("bothSplitOrder responseStr:{}", (Object)responseData);
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothSplitOrderQuery(SplitQueryBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("bothSplitOrderQuery requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getOnlinePaySplitOrderQueryUrl(), requestData);
            LOGGER.info("bothSplitOrderQuery responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("bothSplitOrderQuery responseStr:{}", (Object)responseData);
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

