/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class RefundBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String amount;
    private String refundCurrency;
    private String orderId;
    private String remark;
    private String notifyUrl;

    public RefundBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public RefundBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RefundBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public RefundBuilder setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public RefundBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public RefundBuilder setRefundCurrency(String refundCurrency) {
        this.refundCurrency = refundCurrency;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.refundCurrency)) {
            json.put("refundCurrency", (Object)this.refundCurrency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderId)) {
            json.put("orderId", (Object)this.orderId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.orderId)).append((String)ObjectUtils.defaultIfNull((Object)this.amount, (Object)"")).append(StringUtils.defaultString((String)this.refundCurrency, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl)).append(StringUtils.defaultString((String)this.remark));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

