/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.prepay.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SellOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String amount;
    private String number;

    public SellOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public SellOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public SellOrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public SellOrderBuilder setNumber(String number) {
        this.number = number;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.number)) {
            json.put("number", (Object)this.number);
        }
        String generateHmac = this.generateHmac();
        json.put("hmac", (Object)generateHmac);
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append((String)ObjectUtils.defaultIfNull((Object)this.amount, (Object)"")).append(StringUtils.defaultString((String)this.number, (String)""));
        String source = hmacSource.toString();
        return SignUtils.signMd5(source, ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

