/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.prepay.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;

public class SellQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;

    public SellQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public SellQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        String generateHmac = this.generateHmac();
        json.put("hmac", (Object)generateHmac);
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId));
        String source = hmacSource.toString();
        return SignUtils.signMd5(source, ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

