/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.prepay.executer;

import com.alibaba.fastjson15.JSONArray;
import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.PrepayConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.HmacArray;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SellQueryExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(SellQueryExecuter.class);
    static final Object[] QUERY_RESPONSE_HMAC_FIELDS = new Object[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, "status", "serialNumber", "completeDateTime", "amount", HmacArray.create("card", new String[]{"cardNo", "password"})};

    public void query(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "],prepaySellOrderURl:[" + ConfigurationUtils.getPrepaySellQueryURl() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getPrepaySellQueryURl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        JSONArray array = responseData.getJSONArray("card");
        String privateKey = PrepayConfigurationUtils.getPrivateKey(requestData.getString("merchantId"));
        JSONArray cardArray = new JSONArray();
        for (Object obj : array) {
            JSONObject json = (JSONObject)obj;
            if (json != null) {
                String cardNo = json.getString("cardNo");
                String password = json.getString("password");
                LOGGER.info("cardNo:[" + cardNo + "],password:[" + password + "],privateKey:[" + privateKey + "]");
                try {
                    cardNo = RSAUtils.decreptData(cardNo, privateKey);
                }
                catch (Exception e) {
                    LOGGER.info("cardNo decrypt failure", (Throwable)e);
                }
                try {
                    password = RSAUtils.decreptData(password, privateKey);
                }
                catch (Exception e) {
                    LOGGER.info("password decrypt failure", (Throwable)e);
                }
                json.put("cardNo", (Object)cardNo);
                json.put("password", (Object)password);
                cardArray.add(json);
                continue;
            }
            LOGGER.info("do nothing.", (Object)json);
        }
        responseData.put("card", (Object)cardArray);
        if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            resultListener.success(responseData);
        } else if (Constants.INIT.equals(responseData.getString(Constants.STATUS))) {
            resultListener.failure(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }
}

