/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transfer.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public class ValidateBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String creditedCurrency;
    private String singleReceiveAccount;
    private String detailPath;
    private String notifyUrl;
    private String transferBusinessType;

    public ValidateBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public ValidateBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ValidateBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public ValidateBuilder setDetailPath(String detailPath) {
        this.detailPath = detailPath;
        return this;
    }

    public ValidateBuilder setCreditedCurrency(String creditedCurrency) {
        this.creditedCurrency = creditedCurrency;
        return this;
    }

    public ValidateBuilder setSingleReceiveAccount(String singleReceiveAccount) {
        this.singleReceiveAccount = singleReceiveAccount;
        return this;
    }

    public ValidateBuilder setTransferBusinessType(String transferBusinessType) {
        this.transferBusinessType = transferBusinessType;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

