/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transferDomestic.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.TransferDomesticPayee;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SingleOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String currency;
    private String amount;
    private String notifyUrl;
    private String callbackUrl;
    private String remark;
    private TransferDomesticPayee payee;
    private String partnerId;

    public SingleOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public SingleOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public SingleOrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public SingleOrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public SingleOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public SingleOrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public SingleOrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public SingleOrderBuilder setPayee(TransferDomesticPayee payee) {
        this.payee = payee;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public SingleOrderBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            json.put("callbackUrl", (Object)this.callbackUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        json.put("payee", (Object)this.payee);
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append((String)ObjectUtils.defaultIfNull((Object)this.amount, (Object)"")).append(StringUtils.defaultString((String)this.currency, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.callbackUrl, (String)"")).append(StringUtils.defaultString((String)this.remark, (String)""));
        if (this.payee != null) {
            hmacSource.append(StringUtils.defaultString((String)this.payee.getName())).append(StringUtils.defaultString((String)this.payee.getBankCardNum())).append(StringUtils.defaultString((String)this.payee.getBankName())).append(StringUtils.defaultString((String)this.payee.getBranchBankName())).append(StringUtils.defaultString((String)this.payee.getProvince())).append(StringUtils.defaultString((String)this.payee.getCity()));
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        System.out.println("SingleOrderBuilder sdk \u7b7e\u540d :" + super.orderGenerateHmac());
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

