/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class TransferCreateBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String walletId;
    private String targetWalletId;
    private String amount;
    private String currency;
    private String notifyUrl;
    private String callbackUrl;
    private String wakeUpModel;
    private String timeout;
    private String remark;

    public TransferCreateBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public TransferCreateBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public TransferCreateBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public TransferCreateBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public TransferCreateBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public TransferCreateBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public TransferCreateBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public TransferCreateBuilder setTargetWalletId(String targetWalletId) {
        this.targetWalletId = targetWalletId;
        return this;
    }

    public TransferCreateBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public TransferCreateBuilder setWakeUpModel(String wakeUpModel) {
        this.wakeUpModel = wakeUpModel;
        return this;
    }

    public TransferCreateBuilder setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public TransferCreateBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

