/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.executer.ResultListenerAdpater;
import com.upay.sdk.webox.builder.RedPacketBuilder;
import com.upay.sdk.webox.builder.RedPacketGrabBuilder;
import com.upay.sdk.webox.builder.RedPacketGrabHistoryBuilder;
import com.upay.sdk.webox.builder.RedPacketQueryBuilder;
import com.upay.sdk.webox.builder.RedPacketTimeoutReturnBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedPacketExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(RedPacketExecuter.class);

    public void bothCreate(RedPacketBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("RedPacket requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxRedPacketUrl(), requestData);
                LOGGER.info("RedPacket responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothRecharge error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothQuery(RedPacketQueryBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("bothRedPacketQuery requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxRedPacketQueryUrl(), requestData);
                LOGGER.info("bothRedPacketQuery responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothRechargeQuery error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothGrab(RedPacketGrabBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("bothRedPacketGrab requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxRedPacketGrabUrl(), requestData);
                LOGGER.info("bothRedPacketGrab responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothRedPacketGrab error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothGrabHistory(RedPacketGrabHistoryBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("bothGrabHistory requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxRedPacketGrabHistoryUrl(), requestData);
                LOGGER.info("bothGrabHistory responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothGrabHistory error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void bothTimeoutReturn(RedPacketTimeoutReturnBuilder builder, ResultListenerAdpater resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("RedPacket requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getWeboxRedPacketTimeoutReturnUrl(), requestData);
                LOGGER.info("RedPacket responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                if (null == responseData) {
                    throw new ResponseException(responseData);
                }
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothRecharge error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

