/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.withholding.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrderBuilder
extends BuilderSupport {
    static final Logger LOGGER = LoggerFactory.getLogger(OrderBuilder.class);
    private String language;
    private String requestId;
    private String merchantId;
    private String sourceAmount;
    private String currency;
    private String feeBear;
    private String name;
    private String idNum;
    private String bankCardNum;
    private String phoneNum;
    private String productName;
    private String productType;
    private String remarkRequestId;
    private String quantity;
    private String remark;
    private String callbackUrl;
    private String notifyUrl;
    private String userIp;

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OrderBuilder setFeeBear(String feeBear) {
        this.feeBear = feeBear;
        return this;
    }

    public OrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public OrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setSourceAmount(String sourceAmount) {
        this.sourceAmount = sourceAmount;
        return this;
    }

    public OrderBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public OrderBuilder setIdNum(String idNum) {
        this.idNum = idNum;
        return this;
    }

    public OrderBuilder setBankCardNum(String bankCardNum) {
        this.bankCardNum = bankCardNum;
        return this;
    }

    public OrderBuilder setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
        return this;
    }

    public OrderBuilder setProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public OrderBuilder setProductType(String productType) {
        this.productType = productType;
        return this;
    }

    public OrderBuilder setRemarkRequestId(String remarkRequestId) {
        this.remarkRequestId = remarkRequestId;
        return this;
    }

    public OrderBuilder setQuantity(String quantity) {
        this.quantity = "".equals(quantity) || null == quantity ? "1" : quantity;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setLanguage(String language) {
        this.language = language;
        return this;
    }

    public OrderBuilder setUserIp(String userIp) {
        this.userIp = userIp;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourceAmount)) {
            json.put("sourceAmount", (Object)this.sourceAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.feeBear)) {
            json.put("feeBear", (Object)this.feeBear);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            json.put("name", (Object)this.name);
        }
        if (StringUtils.isNotBlank((CharSequence)this.idNum)) {
            json.put("idNum", (Object)this.idNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardNum)) {
            json.put("bankCardNum", (Object)this.bankCardNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.phoneNum)) {
            json.put("phoneNum", (Object)this.phoneNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.productName)) {
            json.put("productName", (Object)this.productName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.productType)) {
            json.put("productType", (Object)this.productType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remarkRequestId)) {
            json.put("remarkRequestId", (Object)this.remarkRequestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.quantity)) {
            json.put("quantity", (Object)this.quantity);
        }
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            json.put("callbackUrl", (Object)this.callbackUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        if (StringUtils.isNotBlank((CharSequence)this.language)) {
            json.put("language", (Object)this.language);
        }
        if (StringUtils.isNotBlank((CharSequence)this.userIp)) {
            json.put("userIp", (Object)this.userIp);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.sourceAmount)).append(StringUtils.defaultString((String)this.currency)).append(StringUtils.defaultString((String)this.feeBear)).append(StringUtils.defaultString((String)this.name)).append(StringUtils.defaultString((String)this.idNum)).append(StringUtils.defaultString((String)this.bankCardNum)).append(StringUtils.defaultString((String)this.phoneNum)).append(StringUtils.defaultString((String)this.productName)).append(StringUtils.defaultString((String)this.productType)).append(StringUtils.defaultString((String)this.remarkRequestId)).append(StringUtils.defaultString((String)this.quantity)).append(StringUtils.defaultString((String)this.callbackUrl)).append(StringUtils.defaultString((String)this.notifyUrl)).append(StringUtils.defaultString((String)this.remark)).append(StringUtils.defaultString((String)this.userIp)).append(StringUtils.defaultString((String)this.language));
        LOGGER.info("hmacSource:" + hmacSource + "key:" + ConfigurationUtils.getHmacKey(this.merchantId));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

