/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.ec;

import java.math.BigInteger;
import org.bouncycastle.by_1_52.crypto.CipherParameters;
import org.bouncycastle.by_1_52.crypto.ec.ECPair;
import org.bouncycastle.by_1_52.crypto.ec.ECPairFactorTransform;
import org.bouncycastle.by_1_52.crypto.params.ECDomainParameters;
import org.bouncycastle.by_1_52.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.by_1_52.math.ec.ECMultiplier;
import org.bouncycastle.by_1_52.math.ec.ECPoint;
import org.bouncycastle.by_1_52.math.ec.FixedPointCombMultiplier;

public class ECFixedTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private BigInteger k;

    public ECFixedTransform(BigInteger k) {
        this.k = k;
    }

    @Override
    public void init(CipherParameters param) {
        if (!(param instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("ECPublicKeyParameters are required for fixed transform.");
        }
        this.key = (ECPublicKeyParameters)param;
    }

    @Override
    public ECPair transform(ECPair cipherText) {
        if (this.key == null) {
            throw new IllegalStateException("ECFixedTransform not initialised");
        }
        ECDomainParameters ec = this.key.getParameters();
        BigInteger n = ec.getN();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        BigInteger k = this.k.mod(n);
        ECPoint[] gamma_phi = new ECPoint[]{basePointMultiplier.multiply(ec.getG(), k).add(cipherText.getX()), this.key.getQ().multiply(k).add(cipherText.getY())};
        ec.getCurve().normalizeAll(gamma_phi);
        return new ECPair(gamma_phi[0], gamma_phi[1]);
    }

    @Override
    public BigInteger getTransformValue() {
        return this.k;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

