/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.by_1_52.crypto.tls.AbstractTlsServer;
import org.bouncycastle.by_1_52.crypto.tls.DefaultTlsCipherFactory;
import org.bouncycastle.by_1_52.crypto.tls.TlsCipher;
import org.bouncycastle.by_1_52.crypto.tls.TlsCipherFactory;
import org.bouncycastle.by_1_52.crypto.tls.TlsCredentials;
import org.bouncycastle.by_1_52.crypto.tls.TlsFatalAlert;
import org.bouncycastle.by_1_52.crypto.tls.TlsKeyExchange;
import org.bouncycastle.by_1_52.crypto.tls.TlsSRPIdentityManager;
import org.bouncycastle.by_1_52.crypto.tls.TlsSRPKeyExchange;
import org.bouncycastle.by_1_52.crypto.tls.TlsSRPLoginParameters;
import org.bouncycastle.by_1_52.crypto.tls.TlsSRPUtils;
import org.bouncycastle.by_1_52.crypto.tls.TlsSignerCredentials;

public class SRPTlsServer
extends AbstractTlsServer {
    protected TlsSRPIdentityManager srpIdentityManager;
    protected byte[] srpIdentity = null;
    protected TlsSRPLoginParameters loginParameters = null;

    public SRPTlsServer(TlsSRPIdentityManager srpIdentityManager) {
        this(new DefaultTlsCipherFactory(), srpIdentityManager);
    }

    public SRPTlsServer(TlsCipherFactory cipherFactory, TlsSRPIdentityManager srpIdentityManager) {
        super(cipherFactory);
        this.srpIdentityManager = srpIdentityManager;
    }

    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getCipherSuites() {
        return new int[]{49186, 49183, 49185, 49182, 49184, 49181};
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        super.processClientExtensions(clientExtensions);
        this.srpIdentity = TlsSRPUtils.getSRPExtension(clientExtensions);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        int cipherSuite = super.getSelectedCipherSuite();
        if (TlsSRPUtils.isSRPCipherSuite(cipherSuite)) {
            if (this.srpIdentity != null) {
                this.loginParameters = this.srpIdentityManager.getLoginParameters(this.srpIdentity);
            }
            if (this.loginParameters == null) {
                throw new TlsFatalAlert(115);
            }
        }
        return cipherSuite;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return null;
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.getDSASignerCredentials();
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.getRSASignerCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return this.createSRPKeyExchange(21);
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.createSRPKeyExchange(23);
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.createSRPKeyExchange(22);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49179: 
            case 49180: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 49181: 
            case 49182: 
            case 49183: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 49184: 
            case 49185: 
            case 49186: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int keyExchange) {
        return new TlsSRPKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.srpIdentity, this.loginParameters);
    }
}

