/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.tls;

import org.bouncycastle.by_1_52.crypto.DSA;
import org.bouncycastle.by_1_52.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.by_1_52.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.by_1_52.crypto.signers.ECDSASigner;
import org.bouncycastle.by_1_52.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.by_1_52.crypto.tls.TlsDSASigner;
import org.bouncycastle.by_1_52.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof ECPublicKeyParameters;
    }

    @Override
    protected DSA createDSAImpl(short hashAlgorithm) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(hashAlgorithm)));
    }

    @Override
    protected short getSignatureAlgorithm() {
        return 3;
    }
}

