/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service;

import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.env.ClientEnv;
import com.alipay.mychain.sdk.api.service.BaseService;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.account.CreateAccountRequest;
import com.alipay.mychain.sdk.message.transaction.account.CreateAccountResponse;
import com.alipay.mychain.sdk.message.transaction.account.DepositDataRequest;
import com.alipay.mychain.sdk.message.transaction.account.DepositDataResponse;
import com.alipay.mychain.sdk.message.transaction.account.FreezeAccountRequest;
import com.alipay.mychain.sdk.message.transaction.account.FreezeAccountResponse;
import com.alipay.mychain.sdk.message.transaction.account.IssueAssetsRequest;
import com.alipay.mychain.sdk.message.transaction.account.IssueAssetsResponse;
import com.alipay.mychain.sdk.message.transaction.account.PreResetPubKeyRequest;
import com.alipay.mychain.sdk.message.transaction.account.PreResetPubKeyResponse;
import com.alipay.mychain.sdk.message.transaction.account.RedeemAssetsRequest;
import com.alipay.mychain.sdk.message.transaction.account.RedeemAssetsResponse;
import com.alipay.mychain.sdk.message.transaction.account.RelatedDepositDataRequest;
import com.alipay.mychain.sdk.message.transaction.account.RelatedDepositDataResponse;
import com.alipay.mychain.sdk.message.transaction.account.ResetPubKeyRequest;
import com.alipay.mychain.sdk.message.transaction.account.ResetPubKeyResponse;
import com.alipay.mychain.sdk.message.transaction.account.SetRecoverKeyRequest;
import com.alipay.mychain.sdk.message.transaction.account.SetRecoverKeyResponse;
import com.alipay.mychain.sdk.message.transaction.account.TransferBalanceRequest;
import com.alipay.mychain.sdk.message.transaction.account.TransferBalanceResponse;
import com.alipay.mychain.sdk.message.transaction.account.UnFreezeAccountRequest;
import com.alipay.mychain.sdk.message.transaction.account.UnFreezeAccountResponse;
import com.alipay.mychain.sdk.message.transaction.account.UpdateAuthMapRequest;
import com.alipay.mychain.sdk.message.transaction.account.UpdateAuthMapResponse;
import com.alipay.mychain.sdk.message.transaction.account.UpdateEncryptionKeyRequest;
import com.alipay.mychain.sdk.message.transaction.account.UpdateEncryptionKeyResponse;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.TimerTaskManager;

public class AccountService
extends BaseService {
    public AccountService(INetwork client, TimerTaskManager timerTaskManager, ClientEnv env) {
        super(client, timerTaskManager, env);
    }

    public CreateAccountResponse createAccount(CreateAccountRequest request) {
        if (request.isLocal()) {
            return (CreateAccountResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_ACCOUNT_CREATE, request);
        }
        return (CreateAccountResponse)this.sendSyncTransaction(request);
    }

    public DepositDataResponse depositData(DepositDataRequest request) {
        if (request.isLocal()) {
            return (DepositDataResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_NATIVE_DEPOSIT_DATA, request);
        }
        return (DepositDataResponse)this.sendSyncTransaction(request);
    }

    public int asyncDepositData(DepositDataRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_NATIVE_DEPOSIT_DATA, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public int asyncCreateAccount(CreateAccountRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_ACCOUNT_CREATE, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public UpdateEncryptionKeyResponse updateEncryptionKey(UpdateEncryptionKeyRequest request) {
        if (request.isLocal()) {
            return (UpdateEncryptionKeyResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_UPDATE_ENCRYPTION_KEY, request);
        }
        return (UpdateEncryptionKeyResponse)this.sendSyncTransaction(request);
    }

    public int asyncUpdateEncryptionKey(UpdateEncryptionKeyRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_UPDATE_ENCRYPTION_KEY, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public SetRecoverKeyResponse setRecoverKey(SetRecoverKeyRequest request) {
        if (request.isLocal()) {
            return (SetRecoverKeyResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_SET_RECOVERY_KEY, request);
        }
        return (SetRecoverKeyResponse)this.sendSyncTransaction(request);
    }

    public int asyncSetRecoverKey(SetRecoverKeyRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_SET_RECOVERY_KEY, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public PreResetPubKeyResponse preResetPubKey(PreResetPubKeyRequest request) {
        if (request.isLocal()) {
            return (PreResetPubKeyResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_PRE_RESET_PUB_KEY, request);
        }
        return (PreResetPubKeyResponse)this.sendSyncTransaction(request);
    }

    public int asyncPreResetPubKey(PreResetPubKeyRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_PRE_RESET_PUB_KEY, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public ResetPubKeyResponse resetPublicKey(ResetPubKeyRequest request) {
        if (request.isLocal()) {
            return (ResetPubKeyResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_RESET_PUB_KEY, request);
        }
        return (ResetPubKeyResponse)this.sendSyncTransaction(request);
    }

    public int asyncResetPubKey(ResetPubKeyRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_RESET_PUB_KEY, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public TransferBalanceResponse transferBalance(TransferBalanceRequest request) {
        if (request.isLocal()) {
            return (TransferBalanceResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_TRANS_BALANCE, request);
        }
        return (TransferBalanceResponse)this.sendSyncTransaction(request);
    }

    public int asyncTransferBalance(TransferBalanceRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_TRANS_BALANCE, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public UpdateAuthMapResponse updateAuthMap(UpdateAuthMapRequest request) {
        if (request.isLocal()) {
            return (UpdateAuthMapResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_UPDATE_AUTH_MAP, request);
        }
        return (UpdateAuthMapResponse)this.sendSyncTransaction(request);
    }

    public int asyncUpdateAuthMap(UpdateAuthMapRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_UPDATE_AUTH_MAP, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public FreezeAccountResponse freezeAccount(FreezeAccountRequest request) {
        if (request.isLocal()) {
            return (FreezeAccountResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_FREEZE_ACCOUNT, request);
        }
        return (FreezeAccountResponse)this.sendSyncTransaction(request);
    }

    public int asyncFreezeAccount(FreezeAccountRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_FREEZE_ACCOUNT, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public UnFreezeAccountResponse unFreezeAccount(UnFreezeAccountRequest request) {
        if (request.isLocal()) {
            return (UnFreezeAccountResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_UNFREEZE_ACCOUNT, request);
        }
        return (UnFreezeAccountResponse)this.sendSyncTransaction(request);
    }

    public int asyncUnFreezeAccount(UnFreezeAccountRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_UNFREEZE_ACCOUNT, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public RelatedDepositDataResponse relatedDepositData(RelatedDepositDataRequest request) {
        if (request.isLocal()) {
            return (RelatedDepositDataResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_RELATED_DEPOSIT_DATA, request);
        }
        return (RelatedDepositDataResponse)this.sendSyncTransaction(request);
    }

    public int asyncRelatedDepositData(RelatedDepositDataRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_RELATED_DEPOSIT_DATA, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public IssueAssetsResponse issueAssets(IssueAssetsRequest request) {
        if (request.isLocal()) {
            return (IssueAssetsResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_ASSETS_ISSUE, request);
        }
        return (IssueAssetsResponse)this.sendSyncTransaction(request);
    }

    public int asyncIssueAssets(IssueAssetsRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_ASSETS_ISSUE, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }

    public RedeemAssetsResponse redeemAssets(RedeemAssetsRequest request) {
        if (request.isLocal()) {
            return (RedeemAssetsResponse)this.sendLocalTransaction(MessageType.MSG_TYPE_TX_RESP_ASSETS_REDEEM, request);
        }
        return (RedeemAssetsResponse)this.sendSyncTransaction(request);
    }

    public int asyncRedeemAssets(RedeemAssetsRequest request, IAsyncCallback callback) {
        if (request.isLocal()) {
            return this.sendAsyncLocalTransaction(MessageType.MSG_TYPE_TX_RESP_ASSETS_REDEEM, request, callback);
        }
        return this.sendAsyncTransaction(request, callback);
    }
}

