/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service;

import com.alibaba.fastjson.JSON;
import com.alipay.mychain.sdk.api.MychainClient;
import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.callback.IConnectionCallback;
import com.alipay.mychain.sdk.api.callback.IEventCallback;
import com.alipay.mychain.sdk.api.callback.IProcessBlockHandler;
import com.alipay.mychain.sdk.api.env.ClientEnv;
import com.alipay.mychain.sdk.api.service.BaseService;
import com.alipay.mychain.sdk.api.service.event.EventConnectCallback;
import com.alipay.mychain.sdk.api.service.event.EventInfo;
import com.alipay.mychain.sdk.api.service.event.EventManager;
import com.alipay.mychain.sdk.api.service.event.EventRegisterTask;
import com.alipay.mychain.sdk.api.service.event.EventTask;
import com.alipay.mychain.sdk.api.service.task.ReliableEventTask;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.event.EventDataType;
import com.alipay.mychain.sdk.domain.event.EventModelType;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.message.event.CancelEventRequest;
import com.alipay.mychain.sdk.message.event.ListenAccountEventRequest;
import com.alipay.mychain.sdk.message.event.ListenBlockEventRequest;
import com.alipay.mychain.sdk.message.event.ListenContractEventRequest;
import com.alipay.mychain.sdk.message.event.ListenEventResponse;
import com.alipay.mychain.sdk.message.event.ListenTopicsEventRequest;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class EventService
extends BaseService {
    private static Set<String> TOPICS = new HashSet<String>(Arrays.asList("create_account", "deploy_contract", "call_contract", "add_node", "activate_node", "delete_node", "update_config", "transfer_balance", "set_recover_key", "update_auth_map", "pre_reset_pub_key", "reset_pub_key", "update_contract", "deposit_data", "related_deposit_data", "update_encryption_key", "freeze_account_contract", "unfreeze_account_contract", "encryption_envelope", "deposit_envelope", "issue_assets", "redeem_assets"));
    private EventManager eventManager = new EventManager();
    private TimerTaskManager timerTaskManager;

    public EventService(INetwork client, TimerTaskManager timerTaskManager, ClientEnv env) {
        super(client, timerTaskManager, env);
    }

    public static Set<String> getTOPICS() {
        return TOPICS;
    }

    @Override
    public boolean start(MychainClient client) {
        if (client == null) {
            return false;
        }
        if (client.getTimerTaskManager() == null) {
            return false;
        }
        this.timerTaskManager = client.getTimerTaskManager();
        if (this.timerTaskManager == null) {
            return false;
        }
        if (this.getNetwork() != null) {
            this.getNetwork().registerEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_ACCOUNT, new IEventCallback(){

                @Override
                public void onEvent(Message message) {
                    EventService.this.eventManager.pushAccountEventHandler(message);
                }
            });
            this.getNetwork().registerEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_CONTRACT, new IEventCallback(){

                @Override
                public void onEvent(Message message) {
                    EventService.this.eventManager.pushContractEventHandler(message);
                }
            });
            this.getNetwork().registerEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_TOPICS, new IEventCallback(){

                @Override
                public void onEvent(Message message) {
                    EventService.this.eventManager.pushTopicsEventHandler(message);
                }
            });
            this.getNetwork().registerEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_BLOCK, new IEventCallback(){

                @Override
                public void onEvent(Message message) {
                    EventService.this.eventManager.pushBlockEventHandler(message);
                }
            });
            if (this.getEnv().getNetworkOption().getOptimalNetworkLinkOption().getEnable().booleanValue()) {
                this.getNetwork().registerOptimalConnectionEventHandler((IConnectionCallback)new EventConnectCallback(this));
            } else {
                this.getNetwork().registerConnectionEventHandler((IConnectionCallback)new EventConnectCallback(this));
            }
        }
        return true;
    }

    @Override
    public boolean stop() {
        if (this.getNetwork() != null) {
            this.getNetwork().unRegisterEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_CONTRACT);
            this.getNetwork().unRegisterEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_TOPICS);
            this.getNetwork().unRegisterEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_ACCOUNT);
            this.getNetwork().unRegisterEventHandler(MessageType.MSG_TYPE_EVENT_PUSH_BLOCK);
        }
        List<EventInfo> eventInfos = this.eventManager.getAllEvent();
        for (EventInfo info : eventInfos) {
            this.unListenEvent(info.getUserEventId(), false);
        }
        return true;
    }

    public BigInteger listenAccount(Identity id, IEventCallback handler, EventModelType type) {
        ListenAccountEventRequest listenAccountEventRequest = new ListenAccountEventRequest(id, type);
        return this.listenEvent(listenAccountEventRequest, handler, EventDataType.ACCOUNT, type);
    }

    public BigInteger listenContract(Identity id, IEventCallback handler, EventModelType type) {
        ListenContractEventRequest listenContractEventRequest = new ListenContractEventRequest(id, type);
        return this.listenEvent(listenContractEventRequest, handler, EventDataType.CONTRACT, type);
    }

    public BigInteger listenTopics(List<String> topics, IEventCallback handler, VMTypeEnum vmType, EventModelType type) {
        ArrayList<String> data = new ArrayList<String>();
        if (VMTypeEnum.EVM.getCode() == vmType.getCode()) {
            for (String topic : topics) {
                if (TOPICS.contains(topic)) {
                    data.add(topic);
                    continue;
                }
                data.add(ByteUtils.toHexString(HashFactory.getHash(HashTypeEnum.Keccak).hash(ByteUtils.stringToByteArray(topic))));
            }
        } else if (VMTypeEnum.WASM.getCode() == vmType.getCode()) {
            for (String topic : topics) {
                if (TOPICS.contains(topic)) {
                    data.add(topic);
                    continue;
                }
                data.add(ByteUtils.toHexString(topic));
            }
        } else {
            return BigInteger.ZERO;
        }
        ListenTopicsEventRequest eventTopics = new ListenTopicsEventRequest(data, type);
        return this.listenEvent(eventTopics, handler, EventDataType.TOPIC, type);
    }

    public Long listenTopicsReliably(List<String> topics, IEventCallback handler, IProcessBlockHandler processBlockHandler, VMTypeEnum vmTypeEnum, Boolean isPlainTopic) {
        ReliableEventTask reliableEventTask = new ReliableEventTask(this.getNetwork(), handler, processBlockHandler, topics, vmTypeEnum, isPlainTopic, this.getEnv().getRequestOption().getQueryReceiptIntervalMs() * 4, this.getEnv().getLogger());
        if (this.timerTaskManager != null) {
            return this.timerTaskManager.registerTask(reliableEventTask);
        }
        return 0L;
    }

    public boolean unlistenTopicsReliably(Long taskId) {
        if (this.timerTaskManager != null) {
            this.timerTaskManager.unRegisterTask(taskId);
            return true;
        }
        return false;
    }

    public BigInteger listenBlock(IEventCallback handler, EventModelType type) {
        ListenBlockEventRequest listenBlockEventRequest = new ListenBlockEventRequest(type);
        return this.listenEvent(listenBlockEventRequest, handler, EventDataType.BLOCK, type);
    }

    public boolean unListenAccount(BigInteger eventId) {
        return this.unListenEvent(eventId, true);
    }

    public boolean unListenContract(BigInteger eventId) {
        return this.unListenEvent(eventId, true);
    }

    public boolean unListenTopics(BigInteger eventId) {
        return this.unListenEvent(eventId, true);
    }

    public boolean unListenBlock(BigInteger eventId) {
        return this.unListenEvent(eventId, true);
    }

    public BigInteger listenEvent(Request request, IEventCallback cb, EventDataType dataType, EventModelType modelType) {
        return this.listenEvent(request, cb, dataType, modelType, "");
    }

    public BigInteger listenEvent(Request request, IEventCallback cb, EventDataType dataType, EventModelType modelType, String endpoint) {
        if (this.getEnv().getLogger().isDebugEnabled()) {
            this.getEnv().getLogger().debug("ListenEvent:request:{},event data type:{},event model type:{},endpoint:{}", new Object[]{request.toString(), dataType, modelType, endpoint});
        }
        Response response = null;
        if (this.getEnv().getNetworkOption().getOptimalNetworkLinkOption().getEnable().booleanValue()) {
            if (StringUtils.isEmpty((CharSequence)endpoint)) {
                this.getEnv().getLogger().debug("ListenEvent,endpoint is empty");
                response = this.sendSyncRequest(request);
            } else {
                response = this.getNetwork().sendSyncRequest(request, new Hash(), this.getEnv().getRequestOption().getSendRequestTimeoutMs().intValue(), endpoint);
            }
        } else {
            response = this.sendSyncRequest(request);
        }
        if (response != null && response.isSuccess()) {
            ListenEventResponse listenEventResponse = (ListenEventResponse)response;
            EventInfo eventInfo = new EventInfo(request, cb, dataType, modelType);
            eventInfo.setServerEventId(listenEventResponse.getEventId());
            if (StringUtils.isEmpty((CharSequence)endpoint)) {
                eventInfo.setEndpoint(this.getNetwork().getCurrentConnectionEndpoint());
            } else {
                eventInfo.setEndpoint(endpoint);
            }
            if (this.timerTaskManager != null && EventModelType.PULL.getCode() == eventInfo.getEventModelType().getCode()) {
                EventTask eventTask = new EventTask(eventInfo, this.getNetwork(), this.getEnv().getLogger(), this.getEnv().getRequestOption().getSendRequestTimeoutMs());
                Long taskId = this.timerTaskManager.registerTask(eventTask);
                eventInfo.setTaskId(taskId);
                this.getEnv().getLogger().debug("listenEvent, task id: {}", (Object)taskId);
            }
            return this.eventManager.addEvent(eventInfo);
        }
        return BigInteger.ZERO;
    }

    private boolean unListenEvent(BigInteger userEventId, boolean unListenServer) {
        return this.unListenEvent(userEventId, unListenServer, "");
    }

    private boolean unListenEvent(BigInteger userEventId, boolean unListenServer, String endpoint) {
        EventInfo eventInfo;
        if (this.getEnv().getLogger().isDebugEnabled()) {
            this.getEnv().getLogger().debug("unListenEvent, event id:{},endpoint:{}", (Object)userEventId, (Object)endpoint);
        }
        if ((eventInfo = this.eventManager.delEvent(userEventId)) == null) {
            return false;
        }
        if (this.getEnv().getLogger().isDebugEnabled()) {
            this.getEnv().getLogger().debug("del event,event_info:{}", (Object)JSON.toJSONString((Object)eventInfo));
        }
        if (this.timerTaskManager != null && EventModelType.PULL.getCode() == eventInfo.getEventModelType().getCode()) {
            if (this.getEnv().getLogger().isDebugEnabled()) {
                this.getEnv().getLogger().debug("unregister task:{}", (Object)eventInfo.getTaskId());
            }
            this.timerTaskManager.unRegisterTask(eventInfo.getTaskId());
        }
        if (unListenServer) {
            ArrayList<BigInteger> ids = new ArrayList<BigInteger>();
            ids.add(eventInfo.getServerEventId());
            if (ids.isEmpty()) {
                return false;
            }
            CancelEventRequest cancelEventRequest = new CancelEventRequest(ids);
            if (this.getEnv().getLogger().isDebugEnabled()) {
                this.getEnv().getLogger().debug("unListenEvent server,event id:{},request:{}", (Object)eventInfo.getServerEventId(), (Object)cancelEventRequest.toString());
            }
            if (this.getEnv().getNetworkOption().getOptimalNetworkLinkOption().getEnable().booleanValue()) {
                if (StringUtils.isEmpty((CharSequence)endpoint)) {
                    if (this.getEnv().getLogger().isDebugEnabled()) {
                        this.getEnv().getLogger().debug("unListenEvent server,endpoint is empty.");
                    }
                    this.getNetwork().sendAsyncRequest((Request)cancelEventRequest, new Hash(), new IAsyncCallback(){

                        @Override
                        public void onResponse(int errorCode, Response response) {
                        }
                    }, this.getEnv().getRequestOption().getSendRequestTimeoutMs().intValue());
                } else {
                    this.getNetwork().sendAsyncRequest((Request)cancelEventRequest, new Hash(), new IAsyncCallback(){

                        @Override
                        public void onResponse(int errorCode, Response response) {
                        }
                    }, this.getEnv().getRequestOption().getSendRequestTimeoutMs().intValue(), endpoint);
                }
            } else {
                this.getNetwork().sendAsyncRequest((Request)cancelEventRequest, new Hash(), new IAsyncCallback(){

                    @Override
                    public void onResponse(int errorCode, Response response) {
                    }
                }, this.getEnv().getRequestOption().getSendRequestTimeoutMs().intValue());
            }
        }
        return true;
    }

    public void reRegisterAllEvents(String endpoint) {
        if (this.getEnv().getLogger().isDebugEnabled()) {
            this.getEnv().getLogger().debug("reRegister all event,endpoint {}", (Object)endpoint);
        }
        List<EventInfo> events = this.eventManager.getAllEvent();
        for (EventInfo info : events) {
            this.unListenEvent(info.getUserEventId(), this.getEnv().getNetworkOption().getOptimalNetworkLinkOption().getEnable(), info.getEndpoint());
            BigInteger eventId = this.listenEvent(info.getRequest(), info.getHandler(), info.getDataType(), info.getEventModelType(), endpoint);
            if (BigInteger.ZERO.compareTo(eventId) != 0) continue;
            EventRegisterTask eventRegisterTask = new EventRegisterTask(this, this.timerTaskManager, info.getRequest(), info.getHandler(), info.getDataType(), info.getEventModelType(), endpoint, this.getEnv().getLogger());
            Long taskId = this.timerTaskManager.registerTask(eventRegisterTask);
            info.setTaskId(taskId);
        }
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

