/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.event;

import com.alipay.mychain.sdk.api.callback.IConnectionCallback;
import com.alipay.mychain.sdk.api.service.EventService;
import com.alipay.mychain.sdk.utils.NetUtils;
import java.net.InetSocketAddress;

public class EventConnectCallback
implements IConnectionCallback {
    private EventService eventService;

    public EventConnectCallback(EventService eventService) {
        this.eventService = eventService;
    }

    @Override
    public void onConnect(InetSocketAddress socketAddress) {
        if (this.eventService != null) {
            if (this.eventService.getEnv().getNetworkOption().getOptimalNetworkLinkOption().getEnable().booleanValue()) {
                String endpoint = NetUtils.getIpAddress(socketAddress) + ":" + socketAddress.getPort();
                this.eventService.reRegisterAllEvents(endpoint);
            } else {
                this.eventService.reRegisterAllEvents("");
            }
        }
    }

    @Override
    public void onDisConnect(InetSocketAddress socketAddress) {
    }
}

