/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.event;

import com.alipay.mychain.sdk.api.service.event.EventInfo;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.event.PushAccountEvent;
import com.alipay.mychain.sdk.message.event.PushBlockEvent;
import com.alipay.mychain.sdk.message.event.PushContractEvent;
import com.alipay.mychain.sdk.message.event.PushTopicsEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class EventManager {
    private Map<BigInteger, EventInfo> eventsMap = new ConcurrentHashMap<BigInteger, EventInfo>();
    private AtomicLong sequence = new AtomicLong(1L);

    public BigInteger addEvent(EventInfo eventInfo) {
        BigInteger eventId = BigInteger.valueOf(this.sequence.getAndIncrement());
        if (eventInfo.getUserEventId().compareTo(BigInteger.ZERO) == 0) {
            eventInfo.setUserEventId(eventId);
        }
        this.eventsMap.put(eventInfo.getServerEventId(), eventInfo);
        return eventId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventInfo delEvent(BigInteger userEventId) {
        HashMap<BigInteger, EventInfo> map;
        EventManager eventManager = this;
        synchronized (eventManager) {
            map = new HashMap<BigInteger, EventInfo>(this.eventsMap);
        }
        Set entries = map.entrySet();
        for (Map.Entry item : entries) {
            if (((EventInfo)item.getValue()).getUserEventId().compareTo(userEventId) != 0) continue;
            this.eventsMap.remove(((EventInfo)item.getValue()).getServerEventId());
            return (EventInfo)item.getValue();
        }
        return null;
    }

    public void delAllEvent() {
        this.eventsMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventInfo> getAllEvent() {
        HashMap<BigInteger, EventInfo> map;
        EventManager eventManager = this;
        synchronized (eventManager) {
            map = new HashMap<BigInteger, EventInfo>(this.eventsMap);
        }
        ArrayList<EventInfo> eventInfos = new ArrayList<EventInfo>();
        Set entries = map.entrySet();
        for (Map.Entry item : entries) {
            eventInfos.add((EventInfo)item.getValue());
        }
        return eventInfos;
    }

    public EventInfo getEvent(BigInteger serverEventId) {
        EventInfo eventInfo = this.eventsMap.get(serverEventId);
        return eventInfo;
    }

    public void pushAccountEventHandler(Message msg) {
        PushAccountEvent pushAccountEvent = (PushAccountEvent)msg;
        this.onEventHandler(msg, pushAccountEvent.getId());
    }

    public void pushContractEventHandler(Message msg) {
        PushContractEvent pushContractEvent = (PushContractEvent)msg;
        this.onEventHandler(msg, pushContractEvent.getId());
    }

    public void pushTopicsEventHandler(Message msg) {
        PushTopicsEvent pushTopicsEvent = (PushTopicsEvent)msg;
        this.onEventHandler(msg, pushTopicsEvent.getId());
    }

    public void pushBlockEventHandler(Message msg) {
        PushBlockEvent pushBlockEvent = (PushBlockEvent)msg;
        this.onEventHandler(msg, pushBlockEvent.getId());
    }

    private void onEventHandler(Message msg, BigInteger serverEventId) {
        EventInfo info = this.getEvent(serverEventId);
        if (info != null) {
            info.getHandler().onEvent(msg);
        }
    }
}

