/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.envelope;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.AesGcmCipherV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.EccR1PkeyCipherV1;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class EccR1EnvelopeV1
implements EnvelopeBase {
    private static final int IV_LEN = 12;
    private static final int AUTHTAG_LEN = 16;
    private static final int SEALED_KEY_LEN = 94;
    private List<PkeyCipherBase> pubkeyList;
    private PkeyCipherBase privkey;

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.ENVELOPE_ECCR1_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return this.pubkeyList != null && this.pubkeyList.size() > 0;
    }

    @Override
    public boolean isDecryptor() {
        return this.privkey != null;
    }

    @Override
    public void setPkeyCipherList(List<PkeyCipherBase> pkeyCipherList) {
        if (pkeyCipherList == null || pkeyCipherList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pkeyCipherList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (PkeyCipherBase pkeyCipher : pkeyCipherList) {
            if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_ECCR1_LOCAL_V1) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!pkeyCipher.isEncryptor()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPubkeyList(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pubkeyList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (Keypair keypair : pubkeyList) {
            if (keypair.getType() != KeyTypeEnum.KEY_ECCR1_PKCS8) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!keypair.isPubkey()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            EccR1PkeyCipherV1 pkeyCipher = new EccR1PkeyCipherV1(keypair);
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPrivkey(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair should not null");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_ECCR1_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!keypair.isPrivkey()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = new EccR1PkeyCipherV1(keypair);
    }

    @Override
    public void setPrivkey(PkeyCipherBase pkeyCipher) {
        if (pkeyCipher == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pkeyCipher should not null");
        }
        if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_ECCR1_LOCAL_V1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!pkeyCipher.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = pkeyCipher;
    }

    @Override
    public byte[] envelopeSeal(byte[] plaintext, byte[] secretKey) {
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public keys");
        }
        if (secretKey != null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "secretKey must null!");
        }
        try {
            int pubkeyNr = this.pubkeyList.size();
            Keypair keypair = new Pkcs8KeyOperator().generate(KeyTypeEnum.KEY_ECCR1_PKCS8);
            secretKey = this.kdf(keypair.getPubkeyEncoded());
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            byte[] gcmCipherText = cipher.encrypt(plaintext);
            int totalSize = 2 + pubkeyNr * 94 + gcmCipherText.length;
            byte[] output = new byte[totalSize];
            output[0] = (byte)(pubkeyNr >> 8 & 0xFF);
            output[1] = (byte)(pubkeyNr & 0xFF);
            int index = 2;
            for (PkeyCipherBase publicKey : this.pubkeyList) {
                byte[] secretKeyEncrypted = publicKey.encrypt(secretKey);
                System.arraycopy(secretKeyEncrypted, 0, output, index, secretKeyEncrypted.length);
                index += secretKeyEncrypted.length;
            }
            System.arraycopy(gcmCipherText, 0, output, index, gcmCipherText.length);
            return output;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] envelopeOpen(byte[] cipherText, byte[] secretKey) {
        if (!this.isDecryptor() && secretKey == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        if (cipherText == null || cipherText.length < 2) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher text!");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key!");
        }
        try {
            int pubkeyNr = ((cipherText[0] & 0xFF) << 8) + (cipherText[1] & 0xFF);
            if (pubkeyNr == 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid public key number!");
            }
            int index = 2;
            if (secretKey == null) {
                for (int i = 0; i < pubkeyNr; ++i) {
                    byte[] secretKeyEncrypted = Arrays.copyOfRange(cipherText, index, index + 94);
                    index += 94;
                    try {
                        byte[] tempPubkey = this.privkey.decrypt(secretKeyEncrypted);
                        secretKey = tempPubkey;
                        ++i;
                        break;
                    }
                    catch (Exception e) {
                        if (i != pubkeyNr - 1) continue;
                        throw e;
                    }
                }
            }
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            byte[] gcmCipher = Arrays.copyOfRange(cipherText, 2 + pubkeyNr * 94, cipherText.length);
            byte[] plainText = cipher.decrypt(gcmCipher);
            return plainText;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private byte[] kdf(byte[] input) {
        byte[] hash = HashFactory.getHash().hash(input);
        byte[] hash2 = Arrays.copyOfRange(hash, 16, 32);
        byte[] secretKey = new byte[16];
        for (int i = 0; i < 16; ++i) {
            secretKey[i] = (byte)(hash[i] ^ hash2[i]);
        }
        return secretKey;
    }
}

