/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.envelope;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.AesGcmCipherV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.crypto.pkeycipher.RSAPkeyCipherV1;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAEnvelopeV1
implements EnvelopeBase {
    private static final int NOONCE_IV_LEN = 12;
    private static final int GCM_PARAMETER_LEN = 16;
    private static final int SEALED_KEY_LENGTH = 262;
    private List<PkeyCipherBase> pubkeyList;
    private PkeyCipherBase privkey;

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.ENVELOPE_RSA_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return this.pubkeyList != null && this.pubkeyList.size() > 0;
    }

    @Override
    public boolean isDecryptor() {
        return this.privkey != null;
    }

    @Override
    public void setPkeyCipherList(List<PkeyCipherBase> pkeyCipherList) {
        if (pkeyCipherList == null || pkeyCipherList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pkeyCipherList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (PkeyCipherBase pkeyCipher : pkeyCipherList) {
            if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_RSA_OAEP_LOCAL_V0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!pkeyCipher.isEncryptor()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPubkeyList(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pubkeyList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (Keypair keypair : pubkeyList) {
            if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!keypair.isPubkey()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            RSAPkeyCipherV1 pkeyCipher = new RSAPkeyCipherV1(keypair);
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPrivkey(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair should not null");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!keypair.isPrivkey()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = new RSAPkeyCipherV1(keypair);
    }

    @Override
    public void setPrivkey(PkeyCipherBase pkeyCipher) {
        if (pkeyCipher == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pkeyCipher should not null");
        }
        if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_RSA_OAEP_LOCAL_V1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!pkeyCipher.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = pkeyCipher;
    }

    @Override
    public byte[] envelopeSeal(byte[] plaintext, byte[] secretKey) {
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public keys");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key!");
        }
        try {
            Keypair keypair = new Pkcs8KeyOperator().generate(KeyTypeEnum.KEY_RSA2048_PKCS8);
            secretKey = this.kdf(keypair.getPubkeyEncoded());
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            byte[] gcmCipherText = cipher.encrypt(plaintext);
            int pubkeyNr = this.pubkeyList.size();
            int skeyCipherLength = 262 * pubkeyNr;
            byte[] output = new byte[2 + skeyCipherLength + gcmCipherText.length];
            int index = 2;
            output[0] = (byte)(pubkeyNr >> 8 & 0xFF);
            output[1] = (byte)(pubkeyNr & 0xFF);
            for (PkeyCipherBase publicKey : this.pubkeyList) {
                byte[] encryptedSkey = publicKey.encrypt(secretKey);
                System.arraycopy(encryptedSkey, 0, output, index, encryptedSkey.length);
                index += encryptedSkey.length;
            }
            System.arraycopy(gcmCipherText, 0, output, index, gcmCipherText.length);
            return output;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] envelopeOpen(byte[] cipherText, byte[] secretKey) {
        if (!this.isDecryptor() && secretKey == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        if (cipherText == null || cipherText.length < 2) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher text!");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key!");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            int pubkeyNr = ((cipherText[0] & 0xFF) << 8) + (cipherText[1] & 0xFF);
            if (pubkeyNr == 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid public key number!");
            }
            int index = 2;
            int start = 2 + pubkeyNr * 262;
            int aesCipherTextLen = cipherText.length - start;
            if (aesCipherTextLen <= 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher text, need at least " + (start + 12 + 16 + 1) + "bytes");
            }
            byte[] aesCipherText = new byte[aesCipherTextLen];
            System.arraycopy(cipherText, start, aesCipherText, 0, aesCipherTextLen);
            if (secretKey == null) {
                for (int i = 0; i < pubkeyNr; ++i) {
                    try {
                        byte[] encryptedSkey = Arrays.copyOfRange(cipherText, index, index + 262);
                        index += 262;
                        secretKey = this.privkey.decrypt(encryptedSkey);
                        break;
                    }
                    catch (Exception e) {
                        if (i != pubkeyNr - 1) continue;
                        throw new MychainSdkException(ErrorCode.OTHERS, "no matching encrypted skey");
                    }
                }
            }
            if (secretKey == null || secretKey.length != 16) {
                throw new MychainSdkException(ErrorCode.OTHERS, "no matching encrypted skey");
            }
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            byte[] plainText = cipher.decrypt(aesCipherText);
            return plainText;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private byte[] kdf(byte[] input) {
        byte[] hash = HashFactory.getHash().hash(input);
        byte[] hash2 = Arrays.copyOfRange(hash, 16, 32);
        byte[] secretKey = new byte[16];
        for (int i = 0; i < 16; ++i) {
            secretKey[i] = (byte)(hash[i] ^ hash2[i]);
        }
        return secretKey;
    }
}

