/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.pkeycipher;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;

public class EccK1KDFV1
implements PkeyCipherBase {
    static final ECCurve SECP256K1_CURVE = new SecP256K1Curve();
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    private static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    private BigInteger privkeyInv = null;
    private byte[] privateKey;
    private byte[] publicKey;

    public EccK1KDFV1(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair is null!");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_ECCK1_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] pubKey = keypair.getPubkeyId();
        byte[] priKey = keypair.getPrivkeyId();
        if (!ArrayUtils.isEmpty((byte[])pubKey)) {
            this.publicKey = ArrayUtils.clone((byte[])pubKey);
        }
        if (!ArrayUtils.isEmpty((byte[])priKey)) {
            if (priKey.length != 32) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need private key size 32 but " + priKey.length);
            }
            this.privateKey = ArrayUtils.clone((byte[])priKey);
            if (ArrayUtils.isEmpty((byte[])pubKey)) {
                this.publicKey = this.getPubKeyByPrivkey(priKey);
            }
        }
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.PKEY_KDF_ECCK1_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return !ArrayUtils.isEmpty((byte[])this.publicKey) || !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public boolean isDecryptor() {
        return !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public byte[] encrypt(byte[] k) {
        if (ArrayUtils.isEmpty((byte[])k)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "k should not empty");
        }
        if (k.length != 32) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need k size 32 but " + k.length);
        }
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
        }
        ECPoint q = new SecP256K1Curve().createPoint(ByteUtils.byteArrayToBigInteger(Arrays.copyOfRange(this.publicKey, 0, 32)), ByteUtils.byteArrayToBigInteger(Arrays.copyOfRange(this.publicKey, 32, 64)));
        BigInteger kBig = new BigInteger(1, k);
        ECPoint r = q.multiply(kBig).normalize();
        byte[] output = new byte[70];
        byte[] algoBytes = this.getAlgo().toBytes();
        byte[] pubkeyFp = CryptoUtils.getPubkeyFp(this.publicKey);
        System.arraycopy(algoBytes, 0, output, 0, 2);
        System.arraycopy(pubkeyFp, 0, output, 2, 4);
        System.arraycopy(r.getEncoded(false), 1, output, 6, 64);
        return output;
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) {
        if (ArrayUtils.isEmpty((byte[])ciphertext)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "ciphertext should not empty");
        }
        if (ciphertext.length != 70) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need ciphertext size 70 but " + ciphertext.length);
        }
        if (!this.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        if (AlgoIdEnum.valueOf(ciphertext) != this.getAlgo()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] fpTemp = Arrays.copyOfRange(ciphertext, 2, 6);
        byte[] pubkeyFp = CryptoUtils.getPubkeyFp(this.publicKey);
        if (!Arrays.equals(pubkeyFp, fpTemp)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid public key fingerprint!");
        }
        ECPoint ephemeralPubkeyEnc = new SecP256K1Curve().createPoint(ByteUtils.byteArrayToBigInteger(Arrays.copyOfRange(ciphertext, 6, 38)), ByteUtils.byteArrayToBigInteger(Arrays.copyOfRange(ciphertext, 38, 70)));
        if (this.privkeyInv == null) {
            this.privkeyInv = new BigInteger(1, this.privateKey).modInverse(SECP256K1_CURVE.getOrder());
        }
        ECPoint ephemeralPubkey = ephemeralPubkeyEnc.multiply(this.privkeyInv).normalize();
        return Arrays.copyOfRange(ephemeralPubkey.getEncoded(false), 1, 65);
    }

    private byte[] getPubKeyByPrivkey(byte[] privKey) {
        BigInteger priKeyIn = new BigInteger(1, privKey);
        ECPoint point = CryptoUtils.publicPointFromPrivate(CURVE, priKeyIn);
        return Arrays.copyOfRange(point.getEncoded(false), 1, 65);
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }
}

