/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.signer;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class SM2SignerV1
implements SignerBase {
    private static final X9ECParameters CURVE_PARAMS = GMNamedCurves.getByName((String)"sm2p256v1");
    private static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    private byte[] privateKey;
    private byte[] publicKey;
    private Keypair keypair;

    public SM2SignerV1(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair is null!");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_SM2_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] pubKey = keypair.getPubkeyId();
        byte[] priKey = keypair.getPrivkeyId();
        if (!ArrayUtils.isEmpty((byte[])pubKey)) {
            if (pubKey.length != 65) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need private key size 65 but " + pubKey.length);
            }
            this.publicKey = ArrayUtils.clone((byte[])pubKey);
        }
        if (!ArrayUtils.isEmpty((byte[])priKey)) {
            if (priKey.length != 32) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need private key size 32 but " + priKey.length);
            }
            this.privateKey = ArrayUtils.clone((byte[])priKey);
            if (ArrayUtils.isEmpty((byte[])pubKey)) {
                this.publicKey = this.getPubKeyByPrivkey(priKey);
            }
        }
        this.keypair = keypair;
    }

    public static void main(String[] args) {
        Keypair keypair = new Keypair(Hex.decode((String)"0003048a052d94ebda5640511558a2ea0d30bc03d5a75acc2890b9b28bb70e8f32c46d7a6a0fe547b139bf9f8778b2fabe832b76ee869e4ce90a88ef231ba06208f8bd"), Hex.decode((String)"0003c1366d8d6628856509e99f7858177e8c39362c0651192702dce88f703ffca380"));
        SM2SignerV1 sm2SignerV1 = new SM2SignerV1(keypair);
        boolean res = sm2SignerV1.verify(Hex.decode((String)"0003cd2c4683304402201b972f62162659e961759f11cfe055ef1f78ddc6cbddf5bb274ad9ffaeaff91c022064f02dc299f60764a41f1f5fd974a6b69a0792e9669dee9f12316d041020e78f"), Hex.decode((String)"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824"));
        System.out.println(res);
        String signature = Hex.toHexString((byte[])sm2SignerV1.sign(Hex.decode((String)"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824")));
        System.out.println(signature);
        System.out.println(sm2SignerV1.verify(Hex.decode((String)signature), Hex.decode((String)"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824")));
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.SIGNER_SM2_LOCAL_V1;
    }

    @Override
    public boolean isSigner() {
        return !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public boolean isVerifier() {
        return !ArrayUtils.isEmpty((byte[])this.publicKey) || !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public byte[] sign(byte[] message) {
        if (ArrayUtils.isEmpty((byte[])message)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "message is empty!");
        }
        if (!this.isSigner()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        BigInteger privateKeyD = new BigInteger(1, this.privateKey);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, CURVE);
        SM2Signer sm2Signer = new SM2Signer();
        try {
            ParametersWithID parameters = new ParametersWithID((CipherParameters)new ParametersWithRandom((CipherParameters)privateKeyParameters, SecureRandom.getInstance("SHA1PRNG")), Strings.toByteArray((String)"1234567812345678"));
            sm2Signer.init(true, (CipherParameters)parameters);
            sm2Signer.update(message, 0, message.length);
            byte[] bigIntegers = sm2Signer.generateSignature();
            return this.der2Customize(bigIntegers);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (CryptoException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public boolean verify(byte[] signature, byte[] message) {
        if (!this.isVerifier()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
        }
        if (ArrayUtils.isEmpty((byte[])signature) || signature.length < 6) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need signature size > 6");
        }
        if (!Objects.deepEquals(Arrays.copyOfRange(signature, 0, 2), this.getAlgo().toBytes())) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid algoid!");
        }
        byte[] oriSignature = Arrays.copyOfRange(signature, 6, signature.length);
        if (ArrayUtils.isEmpty((byte[])message)) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "message is empty!");
        }
        byte[] publicKey = this.publicKey;
        byte[] pubX = Arrays.copyOfRange(publicKey, 1, 33);
        byte[] pubY = Arrays.copyOfRange(publicKey, 33, 65);
        ECPoint point = CURVE.getCurve().createPoint(new BigInteger(1, pubX), new BigInteger(1, pubY));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(point, CURVE);
        SM2Signer sm2Signer = new SM2Signer();
        ParametersWithID parametersWithID = new ParametersWithID((CipherParameters)publicKeyParameters, Strings.toByteArray((String)"1234567812345678"));
        sm2Signer.init(false, (CipherParameters)parametersWithID);
        sm2Signer.update(message, 0, message.length);
        return sm2Signer.verifySignature(oriSignature);
    }

    @Override
    public byte[] recover(byte[] sig, byte[] msg) {
        return null;
    }

    private byte[] getPubKeyByPrivkey(byte[] privKey) {
        BigInteger priKeyIn = new BigInteger(1, privKey);
        ECPoint point = CryptoUtils.publicPointFromPrivate(CURVE, priKeyIn);
        byte[] encoded = point.getEncoded(false);
        return encoded;
    }

    private byte[] der2Customize(byte[] derSignature) throws IOException {
        ASN1Sequence asn1Encodables = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])derSignature));
        if (asn1Encodables.size() != 2) {
            return null;
        }
        byte[] sig = new byte[6 + derSignature.length];
        System.arraycopy(this.getAlgo().toBytes(), 0, sig, 0, 2);
        byte[] pkFP = this.getFPWithKeytype(this.keypair, this.publicKey);
        System.arraycopy(CryptoUtils.getPubkeyFp(pkFP), 0, sig, 2, 4);
        System.arraycopy(derSignature, 0, sig, 6, derSignature.length);
        return sig;
    }

    private byte[] customize2Der(byte[] bytesSignature) {
        if (ArrayUtils.isEmpty((byte[])bytesSignature) || bytesSignature.length != 70) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need signature size 70 but " + (ArrayUtils.isEmpty((byte[])bytesSignature) ? 0 : bytesSignature.length));
        }
        if (!AlgoIdEnum.SIGNER_SM2_LOCAL_V1.equals((Object)AlgoIdEnum.valueOf(bytesSignature))) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid algoid!");
        }
        byte[] pkFP = this.getFPWithKeytype(this.keypair, this.publicKey);
        if (!Arrays.equals(Arrays.copyOfRange(bytesSignature, 2, 6), CryptoUtils.getPubkeyFp(pkFP))) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid public key fingerprint!");
        }
        byte[] encoded = new byte[bytesSignature.length - 6];
        System.arraycopy(bytesSignature, 6, encoded, 0, encoded.length);
        DLSequence dlSequence = (DLSequence)DERSequence.getInstance((Object)encoded);
        byte[] r = ((ASN1Integer)dlSequence.getObjectAt(0)).getValue().toByteArray();
        byte[] s = ((ASN1Integer)dlSequence.getObjectAt(1)).getValue().toByteArray();
        return null;
    }

    private byte[] getFPWithKeytype(Keypair keypair, byte[] pk) {
        byte[] keytype = keypair.getType().toBytes();
        byte[] pkFP = new byte[keytype.length + pk.length];
        System.arraycopy(keytype, 0, pkFP, 0, keytype.length);
        System.arraycopy(pk, 0, pkFP, keytype.length, pk.length);
        return pkFP;
    }
}

