/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.account;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.account.AccountStatus;
import com.alipay.mychain.sdk.domain.account.AuthMap;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;

public class Account
extends MychainObject
implements Serializable {
    public static final int TX_FIXED_FIELD_NUM = 11;
    private static final long serialVersionUID = 6929279711721372765L;
    protected short version = (short)2;
    private Identity id = new Identity();
    private BigInteger balance = BigInteger.ZERO;
    private AuthMap authMap = new AuthMap();
    private PublicKey recoverKey = new PublicKey();
    private long recoverTimestamp = 0L;
    private AccountStatus status = AccountStatus.NORMAL;
    private byte[] encryptionKey = new byte[0];

    public static Account builder(Identity hash, BigInteger balance, AuthMap authMap, PublicKey recoverKey, long recoverTimestamp, AccountStatus status, byte[] encryptionKey) {
        Account account = Account.builder(hash, balance, authMap, recoverKey, recoverTimestamp, status);
        account.setEncryptionKey(encryptionKey);
        return account;
    }

    public static Account builder(Identity hash, BigInteger balance, AuthMap authMap, PublicKey recoverKey, long recoverTimestamp, AccountStatus status) {
        Account account = new Account();
        account.setIdentity(hash);
        account.setBalance(balance);
        account.setAuthMap(authMap);
        account.setRecoverKey(recoverKey);
        account.setStatus(status);
        account.setRecoverTimestamp(recoverTimestamp);
        return account;
    }

    public Identity getIdentity() {
        return this.id;
    }

    public void setIdentity(Identity id) {
        this.id = id;
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    public void setBalance(BigInteger balance) {
        this.balance = balance;
    }

    public AuthMap getAuthMap() {
        return this.authMap;
    }

    public void setAuthMap(AuthMap authMap) {
        this.authMap = authMap;
    }

    public PublicKey getRecoverKey() {
        return this.recoverKey;
    }

    public void setRecoverKey(PublicKey recoverKey) {
        this.recoverKey = recoverKey;
    }

    public long getRecoverTimestamp() {
        return this.recoverTimestamp;
    }

    public void setRecoverTimestamp(long recoverTimestamp) {
        this.recoverTimestamp = recoverTimestamp;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(byte[] encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public boolean isValid() {
        return this.id != null && this.balance.compareTo(BigInteger.ZERO) >= 0 && this.authMap != null && this.authMap.getAuthMap() != null && !this.authMap.getAuthMap().isEmpty() && this.recoverKey != null && this.recoverTimestamp >= 0L && this.status != null && this.authMap.isValid();
    }

    @Override
    public byte[] toRlp() {
        byte[] identityBytes = Rlp.encodeElement(this.id.getValue());
        byte[] balanceBytes = Rlp.encodeBigInteger(this.balance);
        byte[] recoverKeyBytes = Rlp.encodeElement(this.recoverKey.getValue());
        byte[] recoverTimeBytes = Rlp.encodeLong(this.recoverTimestamp);
        byte[] statusBytes = Rlp.encodeInt(this.status.getValue());
        byte[] code = Rlp.encodeElement(ArrayUtils.EMPTY_BYTE_ARRAY);
        byte[] storageRootBytes = Rlp.encodeElement(new Identity().getValue());
        byte[] codeHash = Rlp.encodeElement(new Identity().getValue());
        byte[] encryptionKeyBytes = this.encryptionKey == null ? Rlp.encodeElement(ArrayUtils.EMPTY_BYTE_ARRAY) : Rlp.encodeElement(this.encryptionKey);
        byte[] versionBytes = Rlp.encodeList(new byte[][]{Rlp.encodeInt(this.version)});
        byte[] authMapBytes = Rlp.encodeElement(this.authMap.toRlp());
        return Rlp.encodeList(identityBytes, balanceBytes, recoverKeyBytes, recoverTimeBytes, statusBytes, code, storageRootBytes, codeHash, encryptionKeyBytes, versionBytes, authMapBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.id = new Identity(((RlpElement)list.get(0)).getRlpData());
        this.balance = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        this.recoverKey = new PublicKey(((RlpElement)list.get(2)).getRlpData());
        this.recoverTimestamp = ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData());
        this.status = AccountStatus.valueOf(ByteUtils.byteArrayToInt(((RlpElement)list.get(4)).getRlpData()));
        this.encryptionKey = ((RlpElement)list.get(8)).getRlpData();
        this.version = ByteUtils.bytesToShort(((RlpElement)((RlpList)list.get(9)).get(0)).getRlpData());
        this.authMap.fromRlp((RlpList)Rlp.decode2(((RlpElement)list.get(10)).getRlpData()).get(0));
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("id", (Object)ByteUtils.toHexString(this.id.getValue()));
        jsonObject.put("balance", (Object)this.balance);
        jsonObject.put("recovery_key", (Object)ByteUtils.toHexString(this.recoverKey.getValue()));
        jsonObject.put("recovery_time", (Object)this.recoverTimestamp);
        jsonObject.put("status", (Object)this.status.getValue());
        jsonObject.put("encryption_key", (Object)ByteUtils.toHexString(this.encryptionKey));
        jsonObject.put("version", (Object)this.version);
        JSONArray array = new JSONArray();
        this.authMap.toJson(array);
        jsonObject.put("auth_map", (Object)array);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.id = new Identity(jsonObject.getString("id"));
        this.balance = jsonObject.getBigInteger("balance");
        this.recoverKey = new PublicKey(jsonObject.getString("recovery_key"));
        this.recoverTimestamp = jsonObject.getLong("recovery_time");
        this.status = AccountStatus.valueOf(jsonObject.getIntValue("status"));
        this.encryptionKey = ByteUtils.hexStringToBytes(jsonObject.getString("encryption_key"));
        this.version = jsonObject.getShort("version");
        this.authMap.fromJson(jsonObject.getJSONArray("auth_map"));
    }

    public byte[] toStorageRlp() {
        byte[] identityBytes = Rlp.encodeElement(this.id.getValue());
        byte[] balanceBytes = Rlp.encodeBigInteger(this.balance);
        Hash emptyHash = new Hash(HashFactory.getHash().hash(Rlp.encodeString("")));
        byte[] storageRootBytes = Rlp.encodeElement(emptyHash.getValue());
        byte[] codeHashBytes = Rlp.encodeElement(new Hash().getValue());
        Hash authRoot = new Hash(HashFactory.getHash().hash(this.getAuthMap().toRlp()));
        byte[] authRootBytes = Rlp.encodeElement(authRoot.getValue());
        byte[] recoverKeyBytes = Rlp.encodeElement(this.recoverKey.getValue());
        byte[] recoverTimeBytes = Rlp.encodeLong(this.recoverTimestamp);
        byte[] statusBytes = Rlp.encodeInt(this.status.getValue());
        byte[] encryptionKeyBytes = this.encryptionKey == null ? Rlp.encodeElement(ArrayUtils.EMPTY_BYTE_ARRAY) : Rlp.encodeElement(this.encryptionKey);
        byte[] versionBytes = Rlp.encodeInt(this.version);
        return Rlp.encodeList(identityBytes, balanceBytes, storageRootBytes, codeHashBytes, authRootBytes, recoverKeyBytes, recoverTimeBytes, statusBytes, encryptionKeyBytes, versionBytes);
    }
}

