/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.block;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.IHash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class BlockHeader
extends MychainObject {
    private Hash hash = new Hash();
    private Hash parentHash = new Hash();
    private Hash transactionRoot = new Hash();
    private Hash receiptRoot = new Hash();
    private Hash stateRoot = new Hash();
    private Long version;
    private BigInteger number;
    private BigInteger gasUsed;
    private long timestamp;
    private byte[] logBloom;

    public static String calcHash(BlockHeader header) {
        byte[] versionBytes = Rlp.encodeLong(header.getVersion());
        byte[] numberBytes = Rlp.encodeBigInteger(header.getNumber());
        byte[] parentHashBytes = Rlp.encodeElement(header.getParentHash().getValue());
        byte[] transactionRootBytes = Rlp.encodeElement(header.getTransactionRoot().getValue());
        byte[] receiptRootBytes = Rlp.encodeElement(header.getReceiptRoot().getValue());
        byte[] stateRootBytes = Rlp.encodeElement(header.getStateRoot().getValue());
        byte[] gasUsedBytes = Rlp.encodeBigInteger(header.getGasUsed());
        byte[] timestampBytes = Rlp.encodeLong(header.getTimestamp());
        byte[] logBloomBytes = Rlp.encodeElement(header.getLogBloom());
        byte[] data = Rlp.encodeList(versionBytes, numberBytes, parentHashBytes, transactionRootBytes, receiptRootBytes, stateRootBytes, gasUsedBytes, timestampBytes, logBloomBytes);
        IHash iHash = HashFactory.getHash();
        return ByteUtils.toHexString(iHash.hash(data));
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    public Hash getParentHash() {
        return this.parentHash;
    }

    public void setParentHash(Hash parentHash) {
        this.parentHash = parentHash;
    }

    public Hash getTransactionRoot() {
        return this.transactionRoot;
    }

    public void setTransactionRoot(Hash transactionRoot) {
        this.transactionRoot = transactionRoot;
    }

    public Hash getReceiptRoot() {
        return this.receiptRoot;
    }

    public void setReceiptRoot(Hash receiptRoot) {
        this.receiptRoot = receiptRoot;
    }

    public Hash getStateRoot() {
        return this.stateRoot;
    }

    public void setStateRoot(Hash stateRoot) {
        this.stateRoot = stateRoot;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public BigInteger getNumber() {
        return this.number;
    }

    public void setNumber(BigInteger number) {
        this.number = number;
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(BigInteger gasUsed) {
        this.gasUsed = gasUsed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public byte[] getLogBloom() {
        return this.logBloom;
    }

    public void setLogBloom(byte[] logBloom) {
        this.logBloom = logBloom;
    }

    @Override
    public byte[] toRlp() {
        byte[] hashBytes = Rlp.encodeElement(this.hash.getValue());
        byte[] versionBytes = Rlp.encodeLong(this.version);
        byte[] numberBytes = Rlp.encodeBigInteger(this.number);
        byte[] parentHashBytes = Rlp.encodeElement(this.parentHash.getValue());
        byte[] transactionRootBytes = Rlp.encodeElement(this.transactionRoot.getValue());
        byte[] receiptRootBytes = Rlp.encodeElement(this.receiptRoot.getValue());
        byte[] stateRootBytes = Rlp.encodeElement(this.stateRoot.getValue());
        byte[] gasUsedBytes = Rlp.encodeBigInteger(this.gasUsed);
        byte[] timestampBytes = Rlp.encodeLong(this.timestamp);
        byte[] logBloomBytes = Rlp.encodeElement(this.logBloom);
        return Rlp.encodeList(hashBytes, versionBytes, numberBytes, parentHashBytes, transactionRootBytes, receiptRootBytes, stateRootBytes, gasUsedBytes, timestampBytes, logBloomBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.hash = new Hash(((RlpElement)list.get(0)).getRlpData());
        this.version = ByteUtils.byteArrayToLong(((RlpElement)list.get(1)).getRlpData());
        this.number = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(2)).getRlpData());
        this.parentHash = new Hash(((RlpElement)list.get(3)).getRlpData());
        this.transactionRoot = new Hash(((RlpElement)list.get(4)).getRlpData());
        this.receiptRoot = new Hash(((RlpElement)list.get(5)).getRlpData());
        this.stateRoot = new Hash(((RlpElement)list.get(6)).getRlpData());
        this.gasUsed = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(7)).getRlpData());
        this.timestamp = ByteUtils.byteArrayToLong(((RlpElement)list.get(8)).getRlpData());
        this.logBloom = ((RlpElement)list.get(9)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("hash", (Object)ByteUtils.toHexString(this.hash.getValue()));
        jsonObject.put("version", (Object)this.version);
        jsonObject.put("number", (Object)this.number);
        jsonObject.put("parent_hash", (Object)ByteUtils.toHexString(this.parentHash.getValue()));
        jsonObject.put("transaction_root", (Object)ByteUtils.toHexString(this.transactionRoot.getValue()));
        jsonObject.put("receipt_root", (Object)ByteUtils.toHexString(this.receiptRoot.getValue()));
        jsonObject.put("state_root", (Object)ByteUtils.toHexString(this.stateRoot.getValue()));
        jsonObject.put("gas_used", (Object)this.gasUsed);
        jsonObject.put("timestamp", (Object)this.timestamp);
        jsonObject.put("log_bloom", (Object)ByteUtils.toHexString(this.logBloom));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.hash = new Hash(jsonObject.getString("hash"));
        this.version = jsonObject.getLong("version");
        this.number = jsonObject.getBigInteger("number");
        this.parentHash = new Hash(jsonObject.getString("parent_hash"));
        this.transactionRoot = new Hash(jsonObject.getString("transaction_root"));
        this.receiptRoot = new Hash(jsonObject.getString("receipt_root"));
        this.stateRoot = new Hash(jsonObject.getString("state_root"));
        this.gasUsed = jsonObject.getBigInteger("gas_used");
        this.timestamp = jsonObject.getLong("timestamp");
        this.logBloom = ByteUtils.hexStringToBytes(jsonObject.getString("log_bloom"));
    }
}

