/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.block;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class BlockInfo
extends MychainObject {
    private List<Hash> txHashs = new ArrayList<Hash>();
    private List<TransactionReceipt> receiptList = new ArrayList<TransactionReceipt>();
    private BigInteger blockNumber = BigInteger.ZERO;

    public BlockInfo() {
    }

    public BlockInfo(List<Hash> txHashs, List<TransactionReceipt> receiptList, BigInteger blockNumber) {
        this.txHashs = txHashs;
        this.receiptList = receiptList;
        this.blockNumber = blockNumber;
    }

    public List<Hash> getTxHashs() {
        return this.txHashs;
    }

    public void setTxHashs(List<Hash> txHashs) {
        this.txHashs = txHashs;
    }

    public List<TransactionReceipt> getReceiptList() {
        return this.receiptList;
    }

    public void setReceiptList(List<TransactionReceipt> receiptList) {
        this.receiptList = receiptList;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("block_number", (Object)this.blockNumber);
        JSONArray hashArray = new JSONArray();
        for (Hash hash : this.txHashs) {
            hashArray.add((Object)ByteUtils.toHexString(hash.getValue()));
        }
        jsonObject.put("hashes", (Object)hashArray);
        JSONArray receipts = new JSONArray();
        for (TransactionReceipt receipt : this.receiptList) {
            JSONObject receiptJson = new JSONObject();
            receipt.toJson(receiptJson);
            receipts.add((Object)receiptJson);
        }
        jsonObject.put("receipts", (Object)receipts);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.blockNumber = jsonObject.getBigInteger("block_number");
        this.txHashs = new ArrayList<Hash>();
        JSONArray hashArray = jsonObject.getJSONArray("hashes");
        if (hashArray != null) {
            for (int i = 0; i < hashArray.size(); ++i) {
                this.txHashs.add(new Hash(hashArray.getString(i)));
            }
        }
        this.receiptList = new ArrayList<TransactionReceipt>();
        JSONArray receipts = jsonObject.getJSONArray("receipts");
        if (receipts != null) {
            for (int i = 0; i < receipts.size(); ++i) {
                TransactionReceipt receipt = new TransactionReceipt();
                receipt.fromJson(receipts.getJSONObject(i));
                this.receiptList.add(receipt);
            }
        }
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> hashBytes = new ArrayList<byte[]>();
        for (Hash hash : this.txHashs) {
            hashBytes.add(Rlp.encodeElement(hash.getValue()));
        }
        ArrayList<byte[]> receiptBytes = new ArrayList<byte[]>();
        for (TransactionReceipt receipt : this.receiptList) {
            receiptBytes.add(receipt.toRlp());
        }
        return Rlp.encodeList(Rlp.encodeBigInteger(this.blockNumber), Rlp.encodeList(hashBytes), Rlp.encodeList(receiptBytes));
    }

    @Override
    public void fromRlp(RlpList list) {
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(0)).getRlpData());
        RlpList hashList = (RlpList)list.get(1);
        for (RlpElement element : hashList) {
            this.txHashs.add(new Hash(element.getRlpData()));
        }
        RlpList receiptRlpList = (RlpList)list.get(2);
        for (RlpElement element : receiptRlpList) {
            TransactionReceipt transactionReceipt = new TransactionReceipt();
            transactionReceipt.fromRlp((RlpList)element);
            this.receiptList.add(transactionReceipt);
        }
    }
}

