/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.consensus.pbft;

import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;

public class PbftSignatureInfo {
    private long seq = 0L;
    private byte[] digest = null;
    private long view = 0L;

    public static PbftSignatureInfo decode(RlpList list) {
        PbftSignatureInfo pbftSignatureInfo = new PbftSignatureInfo();
        pbftSignatureInfo.view = ByteUtils.byteArrayToLong(((RlpElement)list.get(0)).getRlpData());
        pbftSignatureInfo.seq = ByteUtils.byteArrayToLong(((RlpElement)list.get(1)).getRlpData());
        pbftSignatureInfo.digest = ((RlpElement)list.get(2)).getRlpData();
        return pbftSignatureInfo;
    }

    public static byte[] encodeForError(PbftSignatureInfo signatureInfo) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(Rlp.encodeBigInteger(BigInteger.ZERO));
        data.add(Rlp.encodeBigInteger(BigInteger.valueOf(signatureInfo.getView())));
        data.add(Rlp.encodeBigInteger(BigInteger.valueOf(signatureInfo.getSeq())));
        data.add(Rlp.encodeElement(signatureInfo.getDigest()));
        return Rlp.encodeList(data);
    }

    public static byte[] encode(PbftSignatureInfo signatureInfo) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        data.add(Rlp.encodeBigInteger(BigInteger.valueOf(signatureInfo.getView())));
        data.add(Rlp.encodeBigInteger(BigInteger.valueOf(signatureInfo.getSeq())));
        data.add(Rlp.encodeElement(signatureInfo.getDigest()));
        return Rlp.encodeList(data);
    }

    public long getView() {
        return this.view;
    }

    public void setView(long view) {
        this.view = view;
    }

    public long getSeq() {
        return this.seq;
    }

    public void setSeq(long seq) {
        this.seq = seq;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }
}

