/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.contract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.domain.account.Account;
import com.alipay.mychain.sdk.domain.account.AccountStatus;
import com.alipay.mychain.sdk.domain.account.AuthMap;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;

public class Contract
extends Account {
    private Hash storageRoot = new Hash();
    private Hash codeHash = new Hash();
    private byte[] code;

    public static Contract builder(Identity id, BigInteger balance, AuthMap authMap, PublicKey recoverKey, long recoverTimestamp, AccountStatus status, Hash storageRoot, Hash codeHash, byte[] code) {
        Contract contract = new Contract();
        contract.setIdentity(id);
        contract.setBalance(balance);
        contract.setAuthMap(authMap);
        contract.setRecoverKey(recoverKey);
        contract.setStatus(status);
        contract.setRecoverTimestamp(recoverTimestamp);
        contract.setStorageRoot(storageRoot);
        contract.setCodeHash(codeHash);
        contract.setCode(code);
        return contract;
    }

    public static Contract builder(Identity id, BigInteger balance, AuthMap authMap, PublicKey recoverKey, long recoverTimestamp, AccountStatus status, Hash storageRoot, Hash codeHash, byte[] code, byte[] encryptionKey) {
        Contract contract = Contract.builder(id, balance, authMap, recoverKey, recoverTimestamp, status, storageRoot, codeHash, code);
        contract.setEncryptionKey(encryptionKey);
        return contract;
    }

    public Hash getStorageRoot() {
        return this.storageRoot;
    }

    public void setStorageRoot(Hash storageRoot) {
        this.storageRoot = storageRoot;
    }

    public Hash getCodeHash() {
        return this.codeHash;
    }

    public void setCodeHash(Hash codeHash) {
        this.codeHash = codeHash;
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] code) {
        this.code = code;
    }

    @Override
    public boolean isValid() {
        if (this.codeHash == null || this.storageRoot == null) {
            return false;
        }
        return super.isValid();
    }

    @Override
    public byte[] toRlp() {
        byte[] identityBytes = Rlp.encodeElement(this.getIdentity().getValue());
        byte[] balanceBytes = Rlp.encodeBigInteger(this.getBalance());
        byte[] recoverKeyBytes = Rlp.encodeElement(this.getRecoverKey().getValue());
        byte[] recoverTimeBytes = Rlp.encodeLong(this.getRecoverTimestamp());
        byte[] statusBytes = Rlp.encodeInt(this.getStatus().getValue());
        byte[] codeBytes = Rlp.encodeElement(this.code);
        byte[] storageRootBytes = Rlp.encodeElement(this.storageRoot.getValue());
        byte[] codeHashBytes = Rlp.encodeElement(this.codeHash.getValue());
        byte[] encryptionKeyBytes = this.getEncryptionKey() == null ? Rlp.encodeElement(ArrayUtils.EMPTY_BYTE_ARRAY) : Rlp.encodeElement(this.getEncryptionKey());
        byte[] versionBytes = Rlp.encodeList(new byte[][]{Rlp.encodeInt(this.getVersion())});
        byte[] authMapBytes = Rlp.encodeElement(this.getAuthMap().toRlp());
        return Rlp.encodeList(identityBytes, balanceBytes, recoverKeyBytes, recoverTimeBytes, statusBytes, codeBytes, storageRootBytes, codeHashBytes, encryptionKeyBytes, versionBytes, authMapBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.setIdentity(new Identity(((RlpElement)list.get(0)).getRlpData()));
        this.setBalance(ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData()));
        this.setRecoverKey(new PublicKey(((RlpElement)list.get(2)).getRlpData()));
        this.setRecoverTimestamp(ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData()));
        this.setStatus(AccountStatus.valueOf(ByteUtils.byteArrayToInt(((RlpElement)list.get(4)).getRlpData())));
        this.code = ((RlpElement)list.get(5)).getRlpData();
        this.storageRoot = new Hash(((RlpElement)list.get(6)).getRlpData());
        this.codeHash = new Hash(((RlpElement)list.get(7)).getRlpData());
        this.setEncryptionKey(((RlpElement)list.get(8)).getRlpData());
        this.setVersion(ByteUtils.bytesToShort(((RlpElement)((RlpList)list.get(9)).get(0)).getRlpData()));
        AuthMap authMap = new AuthMap();
        authMap.fromRlp((RlpList)Rlp.decode2(((RlpElement)list.get(10)).getRlpData()).get(0));
        this.setAuthMap(authMap);
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("id", (Object)ByteUtils.toHexString(this.getIdentity().getValue()));
        jsonObject.put("balance", (Object)this.getBalance());
        jsonObject.put("recovery_key", (Object)ByteUtils.toHexString(this.getRecoverKey().getValue()));
        jsonObject.put("recovery_time", (Object)this.getRecoverTimestamp());
        jsonObject.put("status", (Object)this.getStatus().getValue());
        jsonObject.put("code", (Object)ByteUtils.toHexString(this.code));
        jsonObject.put("storage_root", (Object)ByteUtils.toHexString(this.storageRoot.getValue()));
        jsonObject.put("code_hash", (Object)ByteUtils.toHexString(this.codeHash.getValue()));
        jsonObject.put("encryption_key", (Object)ByteUtils.toHexString(this.getEncryptionKey()));
        jsonObject.put("version", (Object)this.getVersion());
        JSONArray array = new JSONArray();
        this.getAuthMap().toJson(array);
        jsonObject.put("auth_map", (Object)array);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.setIdentity(new Identity(jsonObject.getString("id")));
        this.setBalance(jsonObject.getBigInteger("balance"));
        this.setRecoverKey(new PublicKey(jsonObject.getString("recovery_key")));
        this.setRecoverTimestamp(jsonObject.getLong("recovery_time"));
        this.setStatus(AccountStatus.valueOf(jsonObject.getIntValue("status")));
        this.code = ByteUtils.hexStringToBytes(jsonObject.getString("code"));
        this.storageRoot = new Hash(jsonObject.getString("storage_root"));
        this.codeHash = new Hash(jsonObject.getString("code_hash"));
        this.setEncryptionKey(ByteUtils.hexStringToBytes(jsonObject.getString("encryption_key")));
        this.setVersion(jsonObject.getShort("version"));
        this.getAuthMap().fromJson(jsonObject.getJSONArray("auth_map"));
    }

    @Override
    public byte[] toStorageRlp() {
        byte[] identityBytes = Rlp.encodeElement(this.getIdentity().getValue());
        byte[] balanceBytes = Rlp.encodeBigInteger(this.getBalance());
        byte[] storageRootBytes = Rlp.encodeElement(this.storageRoot.getValue());
        byte[] codeHashBytes = Rlp.encodeElement(this.codeHash.getValue());
        Hash authRoot = new Hash(HashFactory.getHash().hash(this.getAuthMap().toRlp()));
        byte[] authRootBytes = Rlp.encodeElement(authRoot.getValue());
        byte[] recoverKeyBytes = Rlp.encodeElement(this.getRecoverKey().getValue());
        byte[] recoverTimeBytes = Rlp.encodeLong(this.getRecoverTimestamp());
        byte[] statusBytes = Rlp.encodeInt(this.getStatus().getValue());
        byte[] encryptionKeyBytes = this.getEncryptionKey() == null ? Rlp.encodeElement(ArrayUtils.EMPTY_BYTE_ARRAY) : Rlp.encodeElement(this.getEncryptionKey());
        byte[] versionBytes = Rlp.encodeInt(this.getVersion());
        return Rlp.encodeList(identityBytes, balanceBytes, storageRootBytes, codeHashBytes, authRootBytes, recoverKeyBytes, recoverTimeBytes, statusBytes, encryptionKeyBytes, versionBytes);
    }
}

