/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.transaction;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Extension;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Transaction
extends MychainObject {
    private static final int TX_FIXED_FIELD_NUM = 12;
    private TransactionType txType = TransactionType.TX_UNKNOWN;
    private byte[] data = null;
    private List<byte[]> signatureList = new ArrayList<byte[]>();
    private Hash hash = new Hash();
    private Identity from = new Identity();
    private Identity to = new Identity();
    private long timestamp = 0L;
    private long period = 0L;
    private BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger nonce = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.ZERO;
    private BigInteger gas = BigInteger.ZERO;
    private BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger value = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.ZERO;
    private List<Extension> extensions = new ArrayList<Extension>();
    private BaseFixedSizeByteArray.Fixed20ByteArray groupId = BaseFixedSizeByteArray.Fixed20ByteArray.defaultValue();
    private short version = (short)2;

    public static Transaction builder(TransactionType txType, byte[] data, List<byte[]> signatureList, Hash hash, Identity from, Identity to, long timestamp, long period, BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger nonce, BigInteger gas, BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger value, List<Extension> extensions, BaseFixedSizeByteArray.Fixed20ByteArray groupId) {
        Transaction transaction = new Transaction();
        transaction.setTxType(txType);
        transaction.setData(data);
        transaction.setSignatureList(signatureList);
        transaction.setHash(hash);
        transaction.setFrom(from);
        transaction.setTo(to);
        transaction.setTimestamp(timestamp);
        transaction.setPeriod(period);
        transaction.setNonce(nonce);
        transaction.setGas(gas);
        transaction.setValue(value);
        transaction.setExtensions(extensions);
        transaction.setGroupId(groupId);
        return transaction;
    }

    public TransactionType getTxType() {
        return this.txType;
    }

    public void setTxType(TransactionType txType) {
        this.txType = txType;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public List<byte[]> getSignatureList() {
        return this.signatureList;
    }

    public void setSignatureList(List<byte[]> signatureList) {
        this.signatureList = signatureList;
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Identity getFrom() {
        return this.from;
    }

    public void setFrom(Identity from) {
        this.from = from;
    }

    public Identity getTo() {
        return this.to;
    }

    public void setTo(Identity to) {
        this.to = to;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger nonce) {
        this.nonce = nonce;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    public void setGas(BigInteger gas) {
        this.gas = gas;
    }

    public BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger getValue() {
        return this.value;
    }

    public void setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger value) {
        this.value = value;
    }

    public byte[] buildData() {
        ArrayList<byte[]> dataRLP = new ArrayList<byte[]>();
        byte[] txType = Rlp.encodeInt(this.getTxType().getValue());
        byte[] timestamp = Rlp.encodeBigInteger(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.getTimestamp()).getValue());
        byte[] nonce = Rlp.encodeBigInteger(this.getNonce().getValue());
        byte[] period = Rlp.encodeBigInteger(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.getPeriod()).getValue());
        byte[] from = Rlp.encodeElement(this.getFrom().getValue());
        byte[] to = Rlp.encodeElement(this.getTo().getValue());
        byte[] value = Rlp.encodeBigInteger(this.getValue().getValue());
        byte[] gas = Rlp.encodeBigInteger(this.getGas());
        byte[] groupId = Rlp.encodeElement(this.getGroupId().getData());
        byte[] data = Rlp.encodeElement(this.getData());
        ArrayList<byte[]> extList = new ArrayList<byte[]>();
        if (this.extensions != null) {
            for (Extension item : this.extensions) {
                extList.add(item.toRlp());
            }
        }
        byte[] extensionsBytes = Rlp.encodeList(extList);
        dataRLP.add(txType);
        dataRLP.add(timestamp);
        dataRLP.add(nonce);
        dataRLP.add(period);
        dataRLP.add(from);
        dataRLP.add(to);
        dataRLP.add(value);
        dataRLP.add(gas);
        dataRLP.add(groupId);
        dataRLP.add(Rlp.encodeInt(this.version));
        dataRLP.add(data);
        dataRLP.add(extensionsBytes);
        return Rlp.encodeList(dataRLP);
    }

    public void calcHash() {
        this.hash = new Hash(HashFactory.getHash().hash(this.buildData()));
    }

    public Hash calcHashForGasWithHold() {
        ArrayList<byte[]> dataRLP = new ArrayList<byte[]>();
        byte[] txType = Rlp.encodeInt(this.getTxType().getValue());
        byte[] timestamp = Rlp.encodeBigInteger(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.getTimestamp()).getValue());
        byte[] nonce = Rlp.encodeBigInteger(this.getNonce().getValue());
        byte[] period = Rlp.encodeBigInteger(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.getPeriod()).getValue());
        byte[] from = Rlp.encodeElement(this.getFrom().getValue());
        byte[] to = Rlp.encodeElement(this.getTo().getValue());
        byte[] value = Rlp.encodeBigInteger(this.getValue().getValue());
        byte[] gas = Rlp.encodeBigInteger(this.getGas());
        byte[] groupId = Rlp.encodeElement(this.getGroupId().getData());
        byte[] data = Rlp.encodeElement(this.getData());
        ArrayList<byte[]> extList = new ArrayList<byte[]>();
        if (this.extensions != null) {
            for (Extension item : this.extensions) {
                if (item.getKey() == 4) continue;
                extList.add(item.toRlp());
            }
        }
        byte[] extensionsBytes = Rlp.encodeList(extList);
        dataRLP.add(txType);
        dataRLP.add(timestamp);
        dataRLP.add(nonce);
        dataRLP.add(period);
        dataRLP.add(from);
        dataRLP.add(to);
        dataRLP.add(value);
        dataRLP.add(gas);
        dataRLP.add(groupId);
        dataRLP.add(Rlp.encodeInt(this.version));
        dataRLP.add(data);
        dataRLP.add(extensionsBytes);
        byte[] dataForHash = Rlp.encodeList(dataRLP);
        return new Hash(HashFactory.getHash().hash(dataForHash));
    }

    public BaseFixedSizeByteArray.Fixed20ByteArray getGroupId() {
        return this.groupId;
    }

    public void setGroupId(BaseFixedSizeByteArray.Fixed20ByteArray groupId) {
        this.groupId = groupId;
    }

    @Override
    public byte[] toRlp() {
        byte[] hashBytes = Rlp.encodeElement(this.hash.getValue());
        byte[] txTypeBytes = Rlp.encodeInt(this.txType.getValue());
        byte[] timestampBytes = Rlp.encodeLong(this.timestamp);
        byte[] nonceBytes = Rlp.encodeBigInteger(this.nonce.getValue());
        byte[] periodBytes = Rlp.encodeLong(this.period);
        byte[] fromBytes = Rlp.encodeElement(this.from.getValue());
        byte[] toBytes = Rlp.encodeElement(this.to.getValue());
        byte[] valueBytes = Rlp.encodeBigInteger(this.value.getValue());
        byte[] gasBytes = Rlp.encodeBigInteger(this.gas);
        byte[] groupIdBytes = Rlp.encodeElement(this.groupId.getData());
        byte[] versionBytes = Rlp.encodeShort(this.version);
        byte[] dataBytes = Rlp.encodeElement(this.data);
        ArrayList<byte[]> sigList = new ArrayList<byte[]>();
        if (this.signatureList != null) {
            for (byte[] item : this.signatureList) {
                sigList.add(Rlp.encodeElement(item));
            }
        }
        byte[] signatureBytes = Rlp.encodeList(sigList);
        ArrayList<byte[]> extList = new ArrayList<byte[]>();
        if (this.extensions != null) {
            for (Extension item : this.extensions) {
                extList.add(item.toRlp());
            }
        }
        byte[] extensionsBytes = Rlp.encodeList(extList);
        return Rlp.encodeList(hashBytes, txTypeBytes, timestampBytes, nonceBytes, periodBytes, fromBytes, toBytes, valueBytes, gasBytes, groupIdBytes, versionBytes, dataBytes, signatureBytes, extensionsBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.hash = new Hash(((RlpElement)list.get(0)).getRlpData());
        this.txType = TransactionType.forNumber(ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData()));
        this.timestamp = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
        this.nonce = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(3)).getRlpData()));
        this.period = ByteUtils.byteArrayToLong(((RlpElement)list.get(4)).getRlpData());
        this.from = new Identity(((RlpElement)list.get(5)).getRlpData());
        this.to = new Identity(((RlpElement)list.get(6)).getRlpData());
        this.value = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(7)).getRlpData()));
        this.gas = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(8)).getRlpData());
        this.groupId = BaseFixedSizeByteArray.Fixed20ByteArray.valueOf(((RlpElement)list.get(9)).getRlpData());
        this.version = ByteUtils.bytesToShort(((RlpElement)list.get(10)).getRlpData());
        this.data = ((RlpElement)list.get(11)).getRlpData();
        RlpList sigList = (RlpList)list.get(12);
        for (RlpElement element : sigList) {
            this.signatureList.add(element.getRlpData());
        }
        RlpList extList = (RlpList)list.get(13);
        for (RlpElement element : extList) {
            Extension item = new Extension();
            item.fromRlp((RlpList)element);
            this.extensions.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("hash", (Object)ByteUtils.toHexString(this.hash.getValue()));
        jsonObject.put("type", (Object)this.txType.getValue());
        jsonObject.put("timestamp", (Object)this.timestamp);
        jsonObject.put("nonce", (Object)this.nonce.getValue());
        jsonObject.put("period", (Object)this.period);
        jsonObject.put("from", (Object)ByteUtils.toHexString(this.from.getValue()));
        jsonObject.put("to", (Object)ByteUtils.toHexString(this.to.getValue()));
        jsonObject.put("value", (Object)this.value.getValue());
        jsonObject.put("gas", (Object)this.gas);
        jsonObject.put("group_id", (Object)ByteUtils.toHexString(this.groupId.getData()));
        jsonObject.put("version", (Object)this.version);
        jsonObject.put("data", (Object)ByteUtils.toHexString(this.data));
        JSONArray jsonArray = new JSONArray();
        if (this.signatureList != null) {
            for (byte[] item : this.signatureList) {
                jsonArray.add((Object)ByteUtils.toHexString(item));
            }
        }
        jsonObject.put("signature", (Object)jsonArray);
        JSONArray extArray = new JSONArray();
        if (this.extensions != null) {
            for (Extension item : this.extensions) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                extArray.add((Object)object);
            }
        }
        jsonObject.put("extensions", (Object)extArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        JSONArray extArray;
        this.hash = new Hash(jsonObject.getString("hash"));
        this.txType = TransactionType.forNumber(jsonObject.getInteger("type"));
        this.timestamp = jsonObject.getLong("timestamp");
        this.nonce = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(jsonObject.getBigInteger("nonce"));
        this.period = jsonObject.getLong("period");
        this.from = new Identity(jsonObject.getString("from"));
        this.to = new Identity(jsonObject.getString("to"));
        this.value = BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(jsonObject.getBigInteger("value"));
        this.gas = jsonObject.getBigInteger("gas");
        this.groupId = BaseFixedSizeByteArray.Fixed20ByteArray.valueOf(ByteUtils.hexStringToBytes(jsonObject.getString("group_id")));
        this.version = jsonObject.getShort("version");
        this.data = ByteUtils.hexStringToBytes(jsonObject.getString("data"));
        JSONArray sigArray = jsonObject.getJSONArray("signature");
        if (sigArray != null) {
            Iterator iterator = sigArray.iterator();
            while (iterator.hasNext()) {
                this.signatureList.add(ByteUtils.hexStringToBytes((String)iterator.next()));
            }
        }
        if ((extArray = jsonObject.getJSONArray("extensions")) != null) {
            Iterator iterator = extArray.iterator();
            while (iterator.hasNext()) {
                Extension object = new Extension();
                object.fromJson((JSONObject)iterator.next());
                this.extensions.add(object);
            }
        }
    }

    public void calcSignature(List<SignerBase> signers) {
        this.signatureList.clear();
        for (SignerBase signer : signers) {
            this.signatureList.add(signer.sign(this.hash.getValue()));
        }
    }
}

