/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message;

import com.alipay.mychain.sdk.errorcode.IErrorCode;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.message.admin.AddGroupChainRequest;
import com.alipay.mychain.sdk.message.admin.AddGroupChainResponse;
import com.alipay.mychain.sdk.message.admin.AdminCommonRequest;
import com.alipay.mychain.sdk.message.admin.AdminCommonResponse;
import com.alipay.mychain.sdk.message.admin.DumpDbRequest;
import com.alipay.mychain.sdk.message.admin.DumpDbResponse;
import com.alipay.mychain.sdk.message.admin.QueryLogLevelRequest;
import com.alipay.mychain.sdk.message.admin.QueryLogLevelResponse;
import com.alipay.mychain.sdk.message.admin.SetLogLevelRequest;
import com.alipay.mychain.sdk.message.admin.SetLogLevelResponse;
import com.alipay.mychain.sdk.message.admin.UpdateBlackListRequest;
import com.alipay.mychain.sdk.message.admin.UpdateBlackListResponse;
import com.alipay.mychain.sdk.message.event.CancelEventRequest;
import com.alipay.mychain.sdk.message.event.CancelEventResponse;
import com.alipay.mychain.sdk.message.event.FetchEventRequest;
import com.alipay.mychain.sdk.message.event.FetchEventResponse;
import com.alipay.mychain.sdk.message.event.ListenAccountEventRequest;
import com.alipay.mychain.sdk.message.event.ListenBlockEventRequest;
import com.alipay.mychain.sdk.message.event.ListenContractEventRequest;
import com.alipay.mychain.sdk.message.event.ListenEventResponse;
import com.alipay.mychain.sdk.message.event.ListenTopicsEventRequest;
import com.alipay.mychain.sdk.message.event.PushAccountEvent;
import com.alipay.mychain.sdk.message.event.PushBlockEvent;
import com.alipay.mychain.sdk.message.event.PushContractEvent;
import com.alipay.mychain.sdk.message.event.PushTopicsEvent;
import com.alipay.mychain.sdk.message.query.QueryAccountRequest;
import com.alipay.mychain.sdk.message.query.QueryAccountResponse;
import com.alipay.mychain.sdk.message.query.QueryAnchorRequest;
import com.alipay.mychain.sdk.message.query.QueryAnchorResponse;
import com.alipay.mychain.sdk.message.query.QueryBlockHeaderByTimestampRequest;
import com.alipay.mychain.sdk.message.query.QueryBlockHeaderByTimestampResponse;
import com.alipay.mychain.sdk.message.query.QueryBlockHeaderRequest;
import com.alipay.mychain.sdk.message.query.QueryBlockHeaderResponse;
import com.alipay.mychain.sdk.message.query.QueryBlockRequest;
import com.alipay.mychain.sdk.message.query.QueryBlockResponse;
import com.alipay.mychain.sdk.message.query.QueryBlockTxReceiptsRequest;
import com.alipay.mychain.sdk.message.query.QueryBlockTxReceiptsResponse;
import com.alipay.mychain.sdk.message.query.QueryContractRequest;
import com.alipay.mychain.sdk.message.query.QueryContractResponse;
import com.alipay.mychain.sdk.message.query.QueryHeartBeatRequest;
import com.alipay.mychain.sdk.message.query.QueryHeartBeatResponse;
import com.alipay.mychain.sdk.message.query.QueryHostInfoRequest;
import com.alipay.mychain.sdk.message.query.QueryHostInfoResponse;
import com.alipay.mychain.sdk.message.query.QueryLastBlockHeaderRequest;
import com.alipay.mychain.sdk.message.query.QueryLastBlockHeaderResponse;
import com.alipay.mychain.sdk.message.query.QueryLastBlockRequest;
import com.alipay.mychain.sdk.message.query.QueryLastBlockResponse;
import com.alipay.mychain.sdk.message.query.QueryNodeTimestampRequest;
import com.alipay.mychain.sdk.message.query.QueryNodeTimestampResponse;
import com.alipay.mychain.sdk.message.query.QueryRelatedTransactionDepositFlagRequest;
import com.alipay.mychain.sdk.message.query.QueryRelatedTransactionDepositFlagResponse;
import com.alipay.mychain.sdk.message.query.QueryRelatedTransactionListRequest;
import com.alipay.mychain.sdk.message.query.QueryRelatedTransactionListResponse;
import com.alipay.mychain.sdk.message.query.QueryRelatedTransactionListSizeRequest;
import com.alipay.mychain.sdk.message.query.QueryRelatedTransactionListSizeResponse;
import com.alipay.mychain.sdk.message.query.QueryTransactionAndReceiptRequest;
import com.alipay.mychain.sdk.message.query.QueryTransactionAndReceiptResponse;
import com.alipay.mychain.sdk.message.query.QueryTransactionListRequest;
import com.alipay.mychain.sdk.message.query.QueryTransactionListResponse;
import com.alipay.mychain.sdk.message.query.QueryTransactionReceiptRequest;
import com.alipay.mychain.sdk.message.query.QueryTransactionReceiptResponse;
import com.alipay.mychain.sdk.message.query.QueryTransactionRequest;
import com.alipay.mychain.sdk.message.query.QueryTransactionResponse;
import com.alipay.mychain.sdk.message.spv.QueryBlockBodiesRequest;
import com.alipay.mychain.sdk.message.spv.QueryBlockBodiesResponse;
import com.alipay.mychain.sdk.message.spv.QueryBlockHeaderInfosRequest;
import com.alipay.mychain.sdk.message.spv.QueryBlockHeaderInfosResponse;
import com.alipay.mychain.sdk.message.spv.QueryBlockProofRequest;
import com.alipay.mychain.sdk.message.spv.QueryBlockProofResponse;
import com.alipay.mychain.sdk.message.spv.QueryBlockReceiptsRequest;
import com.alipay.mychain.sdk.message.spv.QueryBlockReceiptsResponse;
import com.alipay.mychain.sdk.message.spv.QueryLatestStateProofRequest;
import com.alipay.mychain.sdk.message.spv.QueryLatestStateProofResponse;
import com.alipay.mychain.sdk.message.spv.QueryReceiptProofRequest;
import com.alipay.mychain.sdk.message.spv.QueryReceiptProofResponse;
import com.alipay.mychain.sdk.message.spv.QueryStateProofRequest;
import com.alipay.mychain.sdk.message.spv.QueryStateProofResponse;
import com.alipay.mychain.sdk.message.spv.QueryTransactionProofRequest;
import com.alipay.mychain.sdk.message.spv.QueryTransactionProofResponse;
import com.alipay.mychain.sdk.message.status.QueryBlockCacheStatusRequest;
import com.alipay.mychain.sdk.message.status.QueryBlockCacheStatusResponse;
import com.alipay.mychain.sdk.message.status.QueryCommonConsensusStatusRequest;
import com.alipay.mychain.sdk.message.status.QueryCommonConsensusStatusResponse;
import com.alipay.mychain.sdk.message.status.QueryConsensusStatusRequest;
import com.alipay.mychain.sdk.message.status.QueryConsensusStatusResponse;
import com.alipay.mychain.sdk.message.status.QueryContractConfigStatusRequest;
import com.alipay.mychain.sdk.message.status.QueryContractConfigStatusResponse;
import com.alipay.mychain.sdk.message.status.QueryContractNodesStatusRequest;
import com.alipay.mychain.sdk.message.status.QueryContractNodesStatusResponse;
import com.alipay.mychain.sdk.message.status.QueryHostStatusRequest;
import com.alipay.mychain.sdk.message.status.QueryHostStatusResponse;
import com.alipay.mychain.sdk.message.status.QueryMetricsQueryInfoRequest;
import com.alipay.mychain.sdk.message.status.QueryMetricsQueryInfoResponse;
import com.alipay.mychain.sdk.message.status.QueryNodeMetricsStatusRequest;
import com.alipay.mychain.sdk.message.status.QueryNodeMetricsStatusResponse;
import com.alipay.mychain.sdk.message.status.QueryP2PStatusRequest;
import com.alipay.mychain.sdk.message.status.QueryP2PStatusResponse;
import com.alipay.mychain.sdk.message.status.QuerySyncStatusRequest;
import com.alipay.mychain.sdk.message.status.QuerySyncStatusResponse;
import com.alipay.mychain.sdk.message.status.QueryTpsLatencyRequest;
import com.alipay.mychain.sdk.message.status.QueryTpsLatencyResponse;
import com.alipay.mychain.sdk.message.status.QueryTransactionCacheStatusRequest;
import com.alipay.mychain.sdk.message.status.QueryTransactionCacheStatusResponse;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.message.transaction.TransactionReceiptResponse;
import com.alipay.mychain.sdk.message.transaction.account.CreateAccountRequest;
import com.alipay.mychain.sdk.message.transaction.account.CreateAccountResponse;
import com.alipay.mychain.sdk.message.transaction.account.DepositDataRequest;
import com.alipay.mychain.sdk.message.transaction.account.DepositDataResponse;
import com.alipay.mychain.sdk.message.transaction.account.FreezeAccountRequest;
import com.alipay.mychain.sdk.message.transaction.account.FreezeAccountResponse;
import com.alipay.mychain.sdk.message.transaction.account.IssueAssetsRequest;
import com.alipay.mychain.sdk.message.transaction.account.IssueAssetsResponse;
import com.alipay.mychain.sdk.message.transaction.account.PreResetPubKeyRequest;
import com.alipay.mychain.sdk.message.transaction.account.PreResetPubKeyResponse;
import com.alipay.mychain.sdk.message.transaction.account.RedeemAssetsRequest;
import com.alipay.mychain.sdk.message.transaction.account.RedeemAssetsResponse;
import com.alipay.mychain.sdk.message.transaction.account.RelatedDepositDataRequest;
import com.alipay.mychain.sdk.message.transaction.account.RelatedDepositDataResponse;
import com.alipay.mychain.sdk.message.transaction.account.ResetPubKeyRequest;
import com.alipay.mychain.sdk.message.transaction.account.ResetPubKeyResponse;
import com.alipay.mychain.sdk.message.transaction.account.SetRecoverKeyRequest;
import com.alipay.mychain.sdk.message.transaction.account.SetRecoverKeyResponse;
import com.alipay.mychain.sdk.message.transaction.account.TransferBalanceRequest;
import com.alipay.mychain.sdk.message.transaction.account.TransferBalanceResponse;
import com.alipay.mychain.sdk.message.transaction.account.UnFreezeAccountRequest;
import com.alipay.mychain.sdk.message.transaction.account.UnFreezeAccountResponse;
import com.alipay.mychain.sdk.message.transaction.account.UpdateAuthMapRequest;
import com.alipay.mychain.sdk.message.transaction.account.UpdateAuthMapResponse;
import com.alipay.mychain.sdk.message.transaction.account.UpdateEncryptionKeyRequest;
import com.alipay.mychain.sdk.message.transaction.account.UpdateEncryptionKeyResponse;
import com.alipay.mychain.sdk.message.transaction.confidential.ConfidentialRequest;
import com.alipay.mychain.sdk.message.transaction.confidential.ConfidentialResponse;
import com.alipay.mychain.sdk.message.transaction.contract.CallContractRequest;
import com.alipay.mychain.sdk.message.transaction.contract.CallContractResponse;
import com.alipay.mychain.sdk.message.transaction.contract.DeployContractRequest;
import com.alipay.mychain.sdk.message.transaction.contract.DeployContractResponse;
import com.alipay.mychain.sdk.message.transaction.contract.FreezeContractRequest;
import com.alipay.mychain.sdk.message.transaction.contract.FreezeContractResponse;
import com.alipay.mychain.sdk.message.transaction.contract.UnFreezeContractRequest;
import com.alipay.mychain.sdk.message.transaction.contract.UnFreezeContractResponse;
import com.alipay.mychain.sdk.message.transaction.contract.UpdateContractRequest;
import com.alipay.mychain.sdk.message.transaction.contract.UpdateContractResponse;
import com.alipay.mychain.sdk.message.transaction.envelope.CreateGroupRequest;
import com.alipay.mychain.sdk.message.transaction.envelope.CreateGroupResponse;
import com.alipay.mychain.sdk.message.transaction.envelope.DepositEnvelopeRequest;
import com.alipay.mychain.sdk.message.transaction.envelope.DepositEnvelopeResponse;
import com.alipay.mychain.sdk.message.transaction.envelope.JoinGroupRequest;
import com.alipay.mychain.sdk.message.transaction.envelope.JoinGroupResponse;
import com.alipay.mychain.sdk.utils.ReflectionUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;

public class MessageFactory {
    private static final Map<MessageType, Triple<String, String, Class<?>>> MSG_TYPE_LIST = new HashMap();
    private static final Map<String, MessageType> TYPE_STR_LIST = new HashMap<String, MessageType>();
    private static final Map<MessageType, MessageType> REQ_RESP_LIST = new HashMap<MessageType, MessageType>();

    public static String msgTypeToString(MessageType type) {
        if (MSG_TYPE_LIST.containsKey((Object)type)) {
            return (String)MSG_TYPE_LIST.get((Object)type).getLeft();
        }
        return "";
    }

    public static MessageType stringToMsgType(String str) {
        if (TYPE_STR_LIST.containsKey(str)) {
            return TYPE_STR_LIST.get(str);
        }
        return MessageType.MSG_TYPE_INVALID;
    }

    public static String getMsgDesc(MessageType type) {
        if (MSG_TYPE_LIST.containsKey((Object)type)) {
            return (String)MSG_TYPE_LIST.get((Object)type).getMiddle();
        }
        return "";
    }

    public static <T> T createMessage(MessageType type) {
        Object msg;
        if (!MSG_TYPE_LIST.containsKey((Object)type)) {
            return null;
        }
        try {
            msg = ReflectionUtil.newInstance((Class)MSG_TYPE_LIST.get((Object)type).getRight(), new Object[0]);
            if (msg == null) {
                return null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        return msg;
    }

    public static <T> T getResponse(Request request, IErrorCode errorCode) {
        if (!REQ_RESP_LIST.containsKey((Object)request.getMessageType())) {
            return null;
        }
        MessageType respType = REQ_RESP_LIST.get((Object)request.getMessageType());
        if (!MSG_TYPE_LIST.containsKey((Object)respType)) {
            return null;
        }
        Class theClass = (Class)MSG_TYPE_LIST.get((Object)respType).getRight();
        if (theClass == null) {
            return null;
        }
        T resp = MessageFactory.getInstance(respType, request, errorCode, theClass);
        return resp == null ? null : (T)resp;
    }

    public static <T> T getResponse(MessageType type, Request request, IErrorCode errorCode) {
        if (!MSG_TYPE_LIST.containsKey((Object)type)) {
            return null;
        }
        Class theClass = (Class)MSG_TYPE_LIST.get((Object)type).getRight();
        if (theClass == null) {
            return null;
        }
        T resp = MessageFactory.getInstance(type, request, errorCode, theClass);
        return resp == null ? null : (T)resp;
    }

    private static void registerReqMessage(MessageType reqType, MessageType respType, String reqStr, String reqDesc, Class<?> req) {
        MessageFactory.putToMsgTypeList(reqType, reqStr, reqDesc, req);
        if (!TYPE_STR_LIST.containsKey(reqStr)) {
            TYPE_STR_LIST.put(reqStr, reqType);
        }
        if (!REQ_RESP_LIST.containsKey((Object)reqType)) {
            REQ_RESP_LIST.put(reqType, respType);
        }
    }

    private static void registerRespMessage(MessageType respType, String respStr, String respDesc, Class<?> resp) {
        MessageFactory.putToMsgTypeList(respType, respStr, respDesc, resp);
        if (!TYPE_STR_LIST.containsKey(respStr)) {
            TYPE_STR_LIST.put(respStr, respType);
        }
    }

    private static void putToMsgTypeList(MessageType respType, final String respStr, final String respDesc, final Class<?> resp) {
        if (!MSG_TYPE_LIST.containsKey((Object)respType)) {
            MSG_TYPE_LIST.put(respType, new Triple<String, String, Class<?>>(){

                public String getLeft() {
                    return respStr;
                }

                public String getMiddle() {
                    return respDesc;
                }

                public Class<?> getRight() {
                    return resp;
                }
            });
        }
    }

    private static <T> T getInstance(MessageType type, Request request, IErrorCode errorCode, Class<?> theClass) {
        Object resp;
        try {
            resp = ReflectionUtil.newInstance(theClass, new Object[0]);
            if (resp == null) {
                return null;
            }
            ReflectionUtil.setFieldValue(resp, "messageType", (Object)type);
            ReflectionUtil.setFieldValue(resp, "sequenceId", request.getSequenceId());
            ReflectionUtil.setFieldValue(resp, "errorCode", errorCode);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        return (T)resp;
    }

    static {
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_ADMIN_REQ_LOG_LEVEL, MessageType.MSG_TYPE_ADMIN_RESP_LOG_LEVEL, "admin_LogLevel", "admin get log level request", QueryLogLevelRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_ADMIN_RESP_LOG_LEVEL, "admin_LogLevel_Resp", "admin get log level response", QueryLogLevelResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_ADMIN_REQ_UPDATE_LOG_LEVEL, MessageType.MSG_TYPE_ADMIN_RESP_UPDATE_LOG_LEVEL, "admin_UpdateLogLevel", "admin set log level request", SetLogLevelRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_ADMIN_RESP_UPDATE_LOG_LEVEL, "admin_UpdateLogLevel_Resp", "admin set log level response", SetLogLevelResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_ADMIN_REQ_DUMP_DB, MessageType.MSG_TYPE_ADMIN_RESP_DUMP_DB, "admin_DumpDB", "admin dump database request", DumpDbRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_ADMIN_RESP_DUMP_DB, "admin_DumpDB_Resp", "admin dump database response", DumpDbResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_ADMIN_REQ_ADD_GROUP_CHAIN, MessageType.MSG_TYPE_ADMIN_RESP_ADD_GROUP_CHAIN, "admin_AddGroupChain", "add group chain request", AddGroupChainRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_ADMIN_RESP_ADD_GROUP_CHAIN, "admin_AddGroupChain_Resp", "add group chain response", AddGroupChainResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_ADMIN_REQ_UPDATE_BLACK_LIST, MessageType.MSG_TYPE_ADMIN_RESP_UPDATE_BLACK_LIST, "admin_UpdateBlackList", "update black list request", UpdateBlackListRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_ADMIN_RESP_UPDATE_BLACK_LIST, "admin_UpdateBlackList_Resp", "update black list response", UpdateBlackListResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_ADMIN_REQ_COMMON, MessageType.MSG_TYPE_ADMIN_RESP_COMMON, "admin_Common", "admin common request", AdminCommonRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_ADMIN_RESP_COMMON, "admin_Common_Resp", "admin common response", AdminCommonResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_HOST, MessageType.MSG_TYPE_STATUS_RESP_HOST, "query_HostStatus", "query host status request", QueryHostStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_HOST, "query_HostStatus_Resp", "query host status response", QueryHostStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_EVENT_REQ_ACCOUNT, MessageType.MSG_TYPE_EVENT_RESP_FILTER_ID, "event_Account", "listen account event request", ListenAccountEventRequest.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_EVENT_REQ_CONTRACT, MessageType.MSG_TYPE_EVENT_RESP_FILTER_ID, "event_Contract", "listen contract event request", ListenContractEventRequest.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_EVENT_REQ_TOPICS, MessageType.MSG_TYPE_EVENT_RESP_FILTER_ID, "event_Topics", "listen topics event request", ListenTopicsEventRequest.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_EVENT_REQ_BLOCK, MessageType.MSG_TYPE_EVENT_RESP_FILTER_ID, "event_Block", "listen block event request", ListenBlockEventRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_EVENT_RESP_FILTER_ID, "event_listen_Resp", "listen event response", ListenEventResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_EVENT_REQ_FETCH, MessageType.MSG_TYPE_EVENT_RESP_FETCH, "event_Fetch", "fetch event request", FetchEventRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_EVENT_RESP_FETCH, "event_Fetch_Resp", "fetch event response", FetchEventResponse.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_EVENT_PUSH_ACCOUNT, "push_account_event", "push account event", PushAccountEvent.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_EVENT_PUSH_CONTRACT, "push_contract_event", "push contract event", PushContractEvent.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_EVENT_PUSH_TOPICS, "push_topics_event", "push topic event", PushTopicsEvent.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_EVENT_PUSH_BLOCK, "push_block_event", "push block event", PushBlockEvent.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_EVENT_REQ_CANCEL, MessageType.MSG_TYPE_EVENT_RESP_CANCEL, "event_Cancel", "cancel event request", CancelEventRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_EVENT_RESP_CANCEL, "event_Cancel_Resp", "cancel event response", CancelEventResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_LOCAL, MessageType.MSG_TYPE_TX_RESP_LOCAL, "transaction_Local", "local transaction request", AbstractTransactionRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_LOCAL, "transaction_Local_Resp", "local transaction response", TransactionReceiptResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_ACCOUNT_CREATE, MessageType.MSG_TYPE_TX_RESP_ACCOUNT_CREATE, "transaction_CreateAccount", "create account request", CreateAccountRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_ACCOUNT_CREATE, "transaction_CreateAccount_Resp", "create account response", CreateAccountResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_TRANS_BALANCE, MessageType.MSG_TYPE_TX_RESP_TRANS_BALANCE, "transaction_TransferBalance", "transfer balance request", TransferBalanceRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_TRANS_BALANCE, "transaction_TransferBalance_Resp", "transfer balance response", TransferBalanceResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_SET_RECOVERY_KEY, MessageType.MSG_TYPE_TX_RESP_SET_RECOVERY_KEY, "transaction_SetRecoveryKey", "set recovery key request", SetRecoverKeyRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_SET_RECOVERY_KEY, "transaction_SetRecoveryKey_Resp", "set recovery key response", SetRecoverKeyResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_PRE_RESET_PUB_KEY, MessageType.MSG_TYPE_TX_RESP_PRE_RESET_PUB_KEY, "transaction_PreResetPubKey", "preReset public key request", PreResetPubKeyRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_PRE_RESET_PUB_KEY, "transaction_PreResetPubKey_Resp", "preReset public key response", PreResetPubKeyResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_RESET_PUB_KEY, MessageType.MSG_TYPE_TX_RESP_RESET_PUB_KEY, "transaction_ResetPubKey", "reset public key request", ResetPubKeyRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_RESET_PUB_KEY, "transaction_ResetPubKey_Resp", "reset public key response", ResetPubKeyResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_UPDATE_AUTH_MAP, MessageType.MSG_TYPE_TX_RESP_UPDATE_AUTH_MAP, "transaction_UpdateAuthMap", "update auth map request", UpdateAuthMapRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_UPDATE_AUTH_MAP, "transaction_UpdateAuthMap_Resp", "update auth map response", UpdateAuthMapResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_CONTRACT_DEPLOY, MessageType.MSG_TYPE_TX_RESP_CONTRACT_DEPLOY, "transaction_DeployContract", "deploy contract request", DeployContractRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_CONTRACT_DEPLOY, "transaction_DeployContract_Resp", "deploy contract response", DeployContractResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_CONTRACT_CALL, MessageType.MSG_TYPE_TX_RESP_CONTRACT_CALL, "transaction_CallContract", "call contract request", CallContractRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_CONTRACT_CALL, "transaction_CallContract_Resp", "call contract response", CallContractResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_CONTRACT_UPDATE, MessageType.MSG_TYPE_TX_RESP_CONTRACT_UPDATE, "transaction_UpdateContract", "update contract request", UpdateContractRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_CONTRACT_UPDATE, "transaction_UpdateContract_Resp", "update contract response", UpdateContractResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_UPDATE_ENCRYPTION_KEY, MessageType.MSG_TYPE_TX_RESP_UPDATE_ENCRYPTION_KEY, "transaction_UpdateEncryptionKey", "update encryption key request", UpdateEncryptionKeyRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_UPDATE_ENCRYPTION_KEY, "transaction_UpdateEncryptionKey_Resp", "update encryption key response", UpdateEncryptionKeyResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_FREEZE_ACCOUNT, MessageType.MSG_TYPE_TX_RESP_FREEZE_ACCOUNT, "transaction_FreezeAccount", "freeze account request", FreezeAccountRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_FREEZE_ACCOUNT, "transaction_FreezeAccount_Resp", "freeze account response", FreezeAccountResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_UNFREEZE_ACCOUNT, MessageType.MSG_TYPE_TX_RESP_UNFREEZE_ACCOUNT, "transaction_UnFreezeAccount", "unFreeze account request", UnFreezeAccountRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_UNFREEZE_ACCOUNT, "transaction_UnFreezeAccount_Resp", "unFreeze account response", UnFreezeAccountResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_FREEZE_CONTRACT, MessageType.MSG_TYPE_TX_RESP_FREEZE_CONTRACT, "transaction_FreezeContract", "freeze contract request", FreezeContractRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_FREEZE_CONTRACT, "transaction_FreezeContract_Resp", "freeze contract response", FreezeContractResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_UNFREEZE_CONTRACT, MessageType.MSG_TYPE_TX_RESP_UNFREEZE_CONTRACT, "transaction_UnFreezeContract", "unFreeze contract request", UnFreezeContractRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_UNFREEZE_CONTRACT, "transaction_UnFreezeContract_Resp", "unFreeze contract response", UnFreezeContractResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_DEPOSIT_ENVELOPE, MessageType.MSG_TYPE_TX_RESP_DEPOSIT_ENVELOPE, "transaction_DepositEnvelope", "deposit envelope request", DepositEnvelopeRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_DEPOSIT_ENVELOPE, "transaction_DepositEnvelope_Resp", "deposit envelope response", DepositEnvelopeResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_NATIVE_DEPOSIT_DATA, MessageType.MSG_TYPE_TX_RESP_NATIVE_DEPOSIT_DATA, "transaction_NativeDepositData", "deposit data request", DepositDataRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_NATIVE_DEPOSIT_DATA, "transaction_NativeDepositData_Resp", "deposit data response", DepositDataResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_CONFIDENTIAL_TX, MessageType.MSG_TYPE_TX_RESP_CONFIDENTIAL_TX, "transaction_ConfidentialTransaction", "confidential transaction request", ConfidentialRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_CONFIDENTIAL_TX, "transaction_ConfidentialTransaction_Resp", "confidential transaction response", ConfidentialResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_RELATED_DEPOSIT_DATA, MessageType.MSG_TYPE_TX_RESP_RELATED_DEPOSIT_DATA, "transaction_RelatedDepositData", "related deposit data request", RelatedDepositDataRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_RELATED_DEPOSIT_DATA, "transaction_RelatedDepositData_Resp", "related deposit data response", RelatedDepositDataResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_PROOF, MessageType.MSG_TYPE_QUERY_RESP_BLOCK_PROOF, "query_BlockProof", "query block proof request", QueryBlockProofRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_BLOCK_PROOF, "query_BlockProof_Resp", "query block proof response", QueryBlockProofResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_LATEST_STATE_PROOF, MessageType.MSG_TYPE_QUERY_RESP_LATEST_STATE_PROOF, "query_LatestStateProof", "query latest state proof request", QueryLatestStateProofRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_LATEST_STATE_PROOF, "query_LatestStateProof_Resp", "query latest state proof response", QueryLatestStateProofResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_STATE_PROOF, MessageType.MSG_TYPE_QUERY_RESP_STATE_PROOF, "query_StateProof", "query state proof request", QueryStateProofRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_STATE_PROOF, "query_StateProof_Resp", "query state proof response", QueryStateProofResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_TRANSACTION_PROOF, MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_PROOF, "query_TransactionProof", "query transaction proof request", QueryTransactionProofRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_PROOF, "query_TransactionProof_Resp", "query transaction proof response", QueryTransactionProofResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER_INFOS, MessageType.MSG_TYPE_QUERY_RESP_BLOCK_HEADER_INFOS, "query_BlockHeaderInfos", "query block header infos request", QueryBlockHeaderInfosRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_BLOCK_HEADER_INFOS, "query_BlockHeaderInfos_Resp", "query block header infos response", QueryBlockHeaderInfosResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_RECEIPTS, MessageType.MSG_TYPE_QUERY_RESP_BLOCK_RECEIPTS, "query_BlockReceiptInfos", "query block receipts request", QueryBlockReceiptsRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_BLOCK_RECEIPTS, "query_BlockReceiptInfos_Resp", "query block receipts response", QueryBlockReceiptsResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_BODY_INFOS, MessageType.MSG_TYPE_QUERY_RESP_BLOCK_BODY_INFOS, "query_BlockBodyInfos", "query block body infos request", QueryBlockBodiesRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_BLOCK_BODY_INFOS, "query_BlockBodyInfos_Resp", "query block body infos response", QueryBlockBodiesResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_RECEIPT_PROOF, MessageType.MSG_TYPE_QUERY_RESP_RECEIPT_PROOF, "query_ReceiptProof", "query receipt proof request", QueryReceiptProofRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_RECEIPT_PROOF, "query_ReceiptProof_Resp", "query receipt proof response", QueryReceiptProofResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_TS, MessageType.MSG_TYPE_QUERY_RESP_TS, "query_NodeTimestamp", "query receipt proof request", QueryNodeTimestampRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_TS, "query_NodeTimestamp_Resp", "query node timestamp response", QueryNodeTimestampResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_LAST_BLOCK, MessageType.MSG_TYPE_QUERY_RESP_LAST_BLOCK, "query_LastBlock", "query last block request", QueryLastBlockRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_LAST_BLOCK, "query_LastBlock_Resp", "query last block response", QueryLastBlockResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER, MessageType.MSG_TYPE_QUERY_RESP_BLOCK_HEADER, "query_BlockHeader", "query last block request", QueryBlockHeaderRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_BLOCK_HEADER, "query_BlockHeader_Resp", "query last block response", QueryBlockHeaderResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_BLOCK, MessageType.MSG_TYPE_QUERY_RESP_BLOCK, "query_Block", "query block request", QueryBlockRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_BLOCK, "query_Block_Resp", "query block response", QueryBlockResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_RECEIPTS_AND_HASH, MessageType.MSG_TYPE_QUERY_RESP_BLOCK_RECEIPTS_AND_HASH, "query_BlockReceipt", "query block receipt request", QueryBlockTxReceiptsRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_BLOCK_RECEIPTS_AND_HASH, "query_BlockReceipt_Resp", "query block receipt response", QueryBlockTxReceiptsResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_ACCOUNT, MessageType.MSG_TYPE_QUERY_RESP_ACCOUNT, "query_Account", "query account request", QueryAccountRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_ACCOUNT, "query_Account_Resp", "query account response", QueryAccountResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_TRANSACTION, MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION, "query_Transaction", "query transaction request", QueryTransactionRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION, "query_Transaction_Resp", "query transaction response", QueryTransactionResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_TRANSACTION_LIST, MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_LIST, "query_TransactionList", "query transaction list request", QueryTransactionListRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_LIST, "query_TransactionList_Resp", "query transaction list response", QueryTransactionListResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_TX_AND_RECEIPT, MessageType.MSG_TYPE_QUERY_RESP_TX_AND_RECEIPT, "query_Transaction_And_Receipt", "query transaction and receipt request", QueryTransactionAndReceiptRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_TX_AND_RECEIPT, "query_Transaction_And_Receipt_Resp", "query transaction and receipt response", QueryTransactionAndReceiptResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_TRANSACTION_RECEIPT, MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_RECEIPT, "query_TransactionReceipt", "query transaction receipt request", QueryTransactionReceiptRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_RECEIPT, "query_TransactionReceipt_Resp", "query transaction receipt response", QueryTransactionReceiptResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_CONTRACT, MessageType.MSG_TYPE_QUERY_RESP_CONTRACT, "query_Contract", "query contract request", QueryContractRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_CONTRACT, "query_Contract_Resp", "query contract response", QueryContractResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_LAST_BLOCK_HEADER, MessageType.MSG_TYPE_QUERY_RESP_LAST_BLOCK_HEADER, "query_LastBlockHeader", "query last block header request", QueryLastBlockHeaderRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_LAST_BLOCK_HEADER, "query_LastBlockHeader_Resp", "query last block header response", QueryLastBlockHeaderResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_HOST_INFO, MessageType.MSG_TYPE_QUERY_RESP_HOST_INFO, "query_HostInfo", "query host info request", QueryHostInfoRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_HOST_INFO, "query_HostInfo_Resp", "query host info response", QueryHostInfoResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER_BY_TS, MessageType.MSG_TYPE_QUERY_RESP_BLOCK_HEADER_BY_TS, "query_BlockHeaderByTs", "query block header by ts request", QueryBlockHeaderByTimestampRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_BLOCK_HEADER_BY_TS, "query_BlockHeaderByTs_Resp", "query block header by ts response", QueryBlockHeaderByTimestampResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_P2P, MessageType.MSG_TYPE_STATUS_RESP_P2P, "query_P2pStatus", "query p2p status request", QueryP2PStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_P2P, "query_P2pStatus_Resp", "query p2p status response", QueryP2PStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_CONSENSUS, MessageType.MSG_TYPE_STATUS_RESP_PBFT, "query_ConsensusStatus", "query consensus status request", QueryConsensusStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_PBFT, "query_ConsensusStatus_Resp", "query consensus status response", QueryConsensusStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_SYNC, MessageType.MSG_TYPE_STATUS_RESP_SYNC, "query_SyncStatus", "query sync status request", QuerySyncStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_SYNC, "query_SyncStatus_Resp", "query sync status response", QuerySyncStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_TX_CACHE, MessageType.MSG_TYPE_STATUS_RESP_TX_CACHE, "query_TransactionCacheStatus", "query tx cache status request", QueryTransactionCacheStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_TX_CACHE, "query_TransactionCacheStatus_Resp", "query tx cache status response", QueryTransactionCacheStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_BLOCK_CACHE, MessageType.MSG_TYPE_STATUS_RESP_BLOCK_CACHE, "query_BlockCacheStatus", "query block cache status request", QueryBlockCacheStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_BLOCK_CACHE, "query_BlockCacheStatus_Resp", "query block cache status response", QueryBlockCacheStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_CONTRACT_NODES, MessageType.MSG_TYPE_STATUS_RESP_CONTRACT_NODES, "query_ContractNodes", "query contract nodes status request", QueryContractNodesStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_CONTRACT_NODES, "query_ContractNodes_Resp", "query contract nodes status response", QueryContractNodesStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_CONTRACT_CONFIGS, MessageType.MSG_TYPE_STATUS_RESP_CONTRACT_CONFIGS, "query_ContractConfig", "query contract config status request", QueryContractConfigStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_CONTRACT_CONFIGS, "query_ContractConfig_Resp", "query contract config status response", QueryContractConfigStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_ACC_TX_METRICS, MessageType.MSG_TYPE_STATUS_RESP_ACC_TX_METRICS, "query_TransactionMetrics", "query transaction metrics request", QueryNodeMetricsStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_ACC_TX_METRICS, "query_TransactionMetrics_Resp", "query transaction metrics response", QueryNodeMetricsStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_QUERY_METRICS, MessageType.MSG_TYPE_STATUS_RESP_QUERY_METRICS, "query_QueryMetrics", "query metrics of query info request", QueryMetricsQueryInfoRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_QUERY_METRICS, "query_QueryMetrics_Resp", "query metrics of query info response", QueryMetricsQueryInfoResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_TPS_LATENCY_METRICS, MessageType.MSG_TYPE_STATUS_RESP_TPS_LATENCY_METRICS, "query_TpsLatencyMetrics", "query tps latency metrics request", QueryTpsLatencyRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_TPS_LATENCY_METRICS, "query_TpsLatencyMetrics_Resp", "query tps latency metrics response", QueryTpsLatencyResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_STATUS_REQ_COMMON_CONSENSUS, MessageType.MSG_TYPE_STATUS_RESP_COMMON_CONSENSUS, "query_CommonConsensusStatus", "query common consensus status request", QueryCommonConsensusStatusRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_STATUS_RESP_COMMON_CONSENSUS, "query_CommonConsensusStatus_Resp", "query common consensus status response", QueryCommonConsensusStatusResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_RELATED_TX_LIST_SIZE, MessageType.MSG_TYPE_QUERY_RESP_RELATED_TX_LIST_SIZE, "query_RelatedTransactionListSize", "query related tx list size request", QueryRelatedTransactionListSizeRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_RELATED_TX_LIST_SIZE, "query_RelatedTransactionListSize_Resp", "query related tx list size response", QueryRelatedTransactionListSizeResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_RELATED_TX_LIST, MessageType.MSG_TYPE_QUERY_RESP_RELATED_TX_LIST, "query_RelatedTransactionList", "query related tx list request", QueryRelatedTransactionListRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_RELATED_TX_LIST, "query_RelatedTransactionList_Resp", "query related tx list response", QueryRelatedTransactionListResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_RELATED_TX_DEPOSIT_FLAG, MessageType.MSG_TYPE_QUERY_RESP_RELATED_TX_DEPOSIT_FLAG, "query_RelatedTransactionDepositFlag", "query related tx deposit flag request", QueryRelatedTransactionDepositFlagRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_RELATED_TX_DEPOSIT_FLAG, "query_RelatedTransactionDepositFlag_Resp", "query related tx deposit flag response", QueryRelatedTransactionDepositFlagResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_REQ_CLIENT_HEARTBEAT, MessageType.MSG_TYPE_RESP_CLIENT_HEARTBEAT, "heartbeat", "heart beat request", QueryHeartBeatRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_RESP_CLIENT_HEARTBEAT, "heartbeat_Resp", "heart beat response", QueryHeartBeatResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_CREATE_GROUP, MessageType.MSG_TYPE_TX_RESP_CREATE_GROUP, "request_CreateGroup", "create group request", CreateGroupRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_CREATE_GROUP, "createGroup_Resp", "create group response", CreateGroupResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_JOIN_GROUP, MessageType.MSG_TYPE_TX_RESP_JOIN_GROUP, "request_JoinGroup", "join group request", JoinGroupRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_JOIN_GROUP, "joinGroup_Resp", "join group response", JoinGroupResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_ASSETS_ISSUE, MessageType.MSG_TYPE_TX_RESP_ASSETS_ISSUE, "transaction_IssueAssets", "issue assets transaction request", IssueAssetsRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_ASSETS_ISSUE, "transaction_IssueAssets_Resp", "issue assets transaction response", IssueAssetsResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_TX_REQ_ASSETS_REDEEM, MessageType.MSG_TYPE_TX_RESP_ASSETS_REDEEM, "transaction_RedeemAssets", "redeem assets transaction request", RedeemAssetsRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_TX_RESP_ASSETS_REDEEM, "transaction_RedeemAssets_Resp", "redeem assets transaction response", RedeemAssetsResponse.class);
        MessageFactory.registerReqMessage(MessageType.MSG_TYPE_QUERY_REQ_ANCHOR_DATA, MessageType.MSG_TYPE_QUERY_RESP_ANCHOR_DATA, "query_AnchorData", "query anchor data request", QueryAnchorRequest.class);
        MessageFactory.registerRespMessage(MessageType.MSG_TYPE_QUERY_RESP_ANCHOR_DATA, "query_AnchorData_Resp", "query anchor data response", QueryAnchorResponse.class);
    }
}

