/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.admin;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.admin.AdminTaskType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class AdminCommonRequest
extends Request {
    private AdminTaskType type;
    private byte[] data;
    private byte[] signature;

    public AdminCommonRequest() {
        super(MessageType.MSG_TYPE_ADMIN_REQ_COMMON);
    }

    public AdminCommonRequest(AdminTaskType adminTaskType, byte[] data) {
        super(MessageType.MSG_TYPE_ADMIN_REQ_COMMON);
        this.type = adminTaskType;
        this.data = data;
    }

    public boolean sign(SignerBase signer) {
        try {
            this.signature = signer.sign(this.hash().getValue());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Hash hash() {
        byte[] bytes = Rlp.encodeList(Rlp.encodeInt(this.type.getCode()), Rlp.encodeElement(this.data));
        return new Hash(HashFactory.getHash().hash(bytes));
    }

    @Override
    public byte[] toRlp() {
        byte[] signatureBytes = Rlp.encodeElement(this.signature);
        return Rlp.encodeList(super.toRlp(), Rlp.encodeInt(this.type.getCode()), Rlp.encodeElement(this.data), signatureBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.type = AdminTaskType.getType(ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData()));
        this.data = ((RlpElement)list.get(2)).getRlpData();
        this.signature = ((RlpElement)list.get(3)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("type", (Object)this.type.getCode());
        jsonObject.put("data", (Object)ByteUtils.toHexString(this.data));
        jsonObject.put("signature", (Object)ByteUtils.toHexString(this.signature));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.type = AdminTaskType.getType(jsonObject.getIntValue("type"));
        this.data = ByteUtils.hexStringToBytes(jsonObject.getString("data"));
        this.signature = ByteUtils.hexStringToBytes(jsonObject.getString("signature"));
    }
}

