/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.contract.Contract;
import com.alipay.mychain.sdk.message.Message;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PushContractEvent
extends Message {
    private List<Contract> contracts;
    private BigInteger id;

    public PushContractEvent(BigInteger id, List<Contract> contracts) {
        super(MessageType.MSG_TYPE_EVENT_PUSH_CONTRACT);
        this.id = id;
        this.contracts = contracts;
    }

    public PushContractEvent() {
        super(MessageType.MSG_TYPE_EVENT_PUSH_CONTRACT);
    }

    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public List<Contract> getContracts() {
        return this.contracts;
    }

    public void setContracts(List<Contract> contracts) {
        this.contracts = contracts;
    }

    @Override
    public byte[] toRlp() {
        byte[] idBytes = Rlp.encodeBigInteger(this.id);
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (Contract item : this.contracts) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(super.toRlp(), idBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.id = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        this.contracts = new ArrayList<Contract>();
        RlpList data = (RlpList)list.get(2);
        for (RlpElement element : data) {
            Contract item = new Contract();
            item.fromRlp((RlpList)element);
            this.contracts.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("filter_id", (Object)this.id);
        JSONArray jsonArray = new JSONArray();
        if (this.contracts != null) {
            for (Contract item : this.contracts) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("contracts", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.id = jsonObject.getBigInteger("filter_id");
        this.contracts = new ArrayList<Contract>();
        JSONArray jsonArray = jsonObject.getJSONArray("contracts");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                Contract object = new Contract();
                object.fromJson((JSONObject)iterator.next());
                this.contracts.add(object);
            }
        }
    }
}

