/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryAnchorRequest
extends Request {
    private boolean latest = true;
    private BigInteger blockNumber = BigInteger.ZERO;

    public QueryAnchorRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_ANCHOR_DATA);
    }

    public Boolean getLatest() {
        return this.latest;
    }

    public void setLatest(Boolean latest) {
        this.latest = latest;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.blockNumber != null && this.blockNumber.compareTo(BigInteger.ZERO) >= 0;
    }

    @Override
    public byte[] toRlp() {
        byte[] latestBytes = Rlp.encodeByte(this.latest ? (byte)1 : 0);
        byte[] blockNumberBytes = Rlp.encodeBigInteger(this.blockNumber);
        return Rlp.encodeList(super.toRlp(), latestBytes, blockNumberBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.latest = ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData()) != 0;
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("latest", (Object)this.latest);
        jsonObject.put("block_number", (Object)this.blockNumber);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.blockNumber = jsonObject.getBigInteger("block_number");
        this.latest = jsonObject.getBooleanValue("hash");
    }
}

