/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.status.ConsensusInfo;
import com.alipay.mychain.sdk.domain.status.ConsensusInfoEnum;
import com.alipay.mychain.sdk.domain.status.HoneybadgerInfo;
import com.alipay.mychain.sdk.domain.status.PbftInfo;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryCommonConsensusStatusResponse
extends Response {
    private ConsensusInfoEnum type = ConsensusInfoEnum.CONSENSUS_INFO_TYPE_PBFT;
    private byte[] info;

    public QueryCommonConsensusStatusResponse() {
        super(MessageType.MSG_TYPE_STATUS_RESP_COMMON_CONSENSUS);
    }

    public QueryCommonConsensusStatusResponse(ConsensusInfoEnum type, byte[] info) {
        super(MessageType.MSG_TYPE_STATUS_RESP_COMMON_CONSENSUS);
        this.type = type;
        this.info = info;
    }

    public ConsensusInfoEnum getType() {
        return this.type;
    }

    public byte[] getInfo() {
        return this.info;
    }

    public ConsensusInfo getConsensusInfo() {
        if (this.info == null) {
            return null;
        }
        RlpList list = (RlpList)Rlp.decode2(this.info).get(0);
        if (ConsensusInfoEnum.CONSENSUS_INFO_TYPE_PBFT.getCode() == this.type.getCode()) {
            PbftInfo pbftInfo = new PbftInfo();
            pbftInfo.fromRlp(list);
            return pbftInfo;
        }
        if (ConsensusInfoEnum.CONSENSUS_INFO_TYPE_HONEYBADGER.getCode() == this.type.getCode()) {
            HoneybadgerInfo honeybadgerInfo = new HoneybadgerInfo();
            honeybadgerInfo.fromRlp(list);
            return honeybadgerInfo;
        }
        return null;
    }

    @Override
    public byte[] toRlp() {
        byte[] typeBytes = Rlp.encodeInt(this.type.getCode());
        byte[] infoBytes = Rlp.encodeElement(this.info);
        return Rlp.encodeList(super.toRlp(), typeBytes, infoBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.type = ConsensusInfoEnum.forNumber(ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData()));
        this.info = ((RlpElement)list.get(2)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("type", (Object)this.type.getCode());
        jsonObject.put("info", (Object)ByteUtils.toHexString(this.info));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.type = ConsensusInfoEnum.forNumber(jsonObject.getInteger("type"));
        this.info = ByteUtils.hexStringToBytes(jsonObject.getString("info"));
    }
}

