/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import java.math.BigInteger;

public class IssueAssetsRequest
extends AbstractTransactionRequest {
    private Identity id;
    private Identity issuedId;
    private BigInteger value;

    public IssueAssetsRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_ASSETS_ISSUE);
    }

    public IssueAssetsRequest(Identity id, Identity issuedId, BigInteger value) {
        super(MessageType.MSG_TYPE_TX_REQ_ASSETS_ISSUE);
        this.id = id;
        this.issuedId = issuedId;
        this.value = value;
    }

    public Identity getId() {
        return this.id;
    }

    public Identity getIssuedId() {
        return this.issuedId;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.id != null && !this.id.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.issuedId != null && !this.issuedId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.value != null;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_ISSUE_ASSETS);
        transaction.setFrom(this.id);
        transaction.setTo(this.issuedId);
        transaction.setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.value));
        super.complete();
    }
}

