/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import java.math.BigInteger;

public class RedeemAssetsRequest
extends AbstractTransactionRequest {
    private Identity id;
    private Identity redeemedId;
    private BigInteger value;

    public RedeemAssetsRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_ASSETS_REDEEM);
    }

    public RedeemAssetsRequest(Identity id, Identity redeemedId, BigInteger value) {
        super(MessageType.MSG_TYPE_TX_REQ_ASSETS_REDEEM);
        this.id = id;
        this.redeemedId = redeemedId;
        this.value = value;
    }

    public Identity getId() {
        return this.id;
    }

    public Identity getRedeemedId() {
        return this.redeemedId;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.id != null && !this.id.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.redeemedId != null && !this.redeemedId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.value != null;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_REDEEM_ASSETS);
        transaction.setFrom(this.id);
        transaction.setTo(this.redeemedId);
        transaction.setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.value));
        super.complete();
    }
}

