/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import org.apache.commons.lang3.ArrayUtils;

public class SetRecoverKeyRequest
extends AbstractTransactionRequest {
    private Identity acctId;
    private PublicKey recoverPubKey;

    public SetRecoverKeyRequest(Identity acctId, PublicKey recoverPubKey) {
        super(MessageType.MSG_TYPE_TX_REQ_SET_RECOVERY_KEY);
        this.acctId = acctId;
        this.recoverPubKey = recoverPubKey;
    }

    public SetRecoverKeyRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_SET_RECOVERY_KEY);
    }

    public Identity getAcctId() {
        return this.acctId;
    }

    public PublicKey getRecoverPubKey() {
        return this.recoverPubKey;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.acctId != null && !this.acctId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.recoverPubKey != null && ArrayUtils.isNotEmpty((byte[])this.recoverPubKey.getValue());
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_SET_RECOVER_KEY);
        transaction.setFrom(this.acctId);
        transaction.setTo(this.acctId);
        transaction.setData(this.recoverPubKey.getValue());
        super.complete();
    }
}

