/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;

public class UnFreezeAccountRequest
extends AbstractTransactionRequest {
    private Identity id;
    private Identity frozenId;

    public UnFreezeAccountRequest(Identity id, Identity frozenId) {
        super(MessageType.MSG_TYPE_TX_REQ_UNFREEZE_ACCOUNT);
        this.id = id;
        this.frozenId = frozenId;
    }

    public UnFreezeAccountRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_UNFREEZE_ACCOUNT);
    }

    public Hash getId() {
        return this.id;
    }

    public Hash getFrozenId() {
        return this.frozenId;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.id != null && !this.id.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue()) && this.frozenId != null && !this.frozenId.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue()) && !this.id.equals(this.frozenId);
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_UNFREEZE_ACCOUNT_CONTRACT);
        transaction.setFrom(this.id);
        transaction.setTo(this.frozenId);
        super.complete();
    }
}

