/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;

public class UpdateEncryptionKeyRequest
extends AbstractTransactionRequest {
    private Identity acctId;
    private byte[] encryptionKey;

    public UpdateEncryptionKeyRequest(Identity acctId, byte[] encryptionKey) {
        super(MessageType.MSG_TYPE_TX_REQ_UPDATE_ENCRYPTION_KEY);
        this.acctId = acctId;
        this.encryptionKey = encryptionKey;
    }

    public UpdateEncryptionKeyRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_UPDATE_ENCRYPTION_KEY);
    }

    public Identity getAcctId() {
        return this.acctId;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.acctId != null && !this.acctId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.encryptionKey != null && this.encryptionKey.length != 0;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_UPDATE_ENCRYPTION_KEY);
        transaction.setFrom(this.acctId);
        transaction.setTo(this.acctId);
        transaction.setData(this.encryptionKey);
        super.complete();
    }
}

