/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.contract;

import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import com.alipay.mychain.sdk.utils.VMUtils;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;

public class DeployContractRequest
extends AbstractTransactionRequest {
    private Identity acctId;
    private Identity contractId;
    private byte[] code;
    private VMTypeEnum vmTypeEnum;
    private Parameters parameters;
    private BigInteger value = BigInteger.ZERO;

    public DeployContractRequest(Identity acctId, Identity contractId, byte[] code, VMTypeEnum vmTypeEnum, Parameters parameters, BigInteger value) {
        super(MessageType.MSG_TYPE_TX_REQ_CONTRACT_DEPLOY);
        this.acctId = acctId;
        this.contractId = contractId;
        this.code = code;
        this.vmTypeEnum = vmTypeEnum;
        this.parameters = parameters;
        this.value = value;
    }

    public DeployContractRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_CONTRACT_DEPLOY);
    }

    public Identity getAcctId() {
        return this.acctId;
    }

    public Identity getContractId() {
        return this.contractId;
    }

    public byte[] getCode() {
        return this.code;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public VMTypeEnum getVmTypeEnum() {
        return this.vmTypeEnum;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.acctId != null && !this.acctId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.contractId != null && !this.contractId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && ArrayUtils.isNotEmpty((byte[])this.code) && (this.vmTypeEnum == VMTypeEnum.NATIVE || this.vmTypeEnum == VMTypeEnum.EVM || this.vmTypeEnum == VMTypeEnum.WASM || this.vmTypeEnum == VMTypeEnum.NATIVE_PRECOMPILE) && this.parameters != null;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_DEPLOY_CONTRACT);
        transaction.setFrom(this.acctId);
        transaction.setTo(this.contractId);
        transaction.setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.value));
        byte[] pa = null;
        if (this.parameters != null) {
            pa = this.parameters.getData();
        }
        transaction.setData(VMUtils.constructDeployData(this.vmTypeEnum, this.code, pa));
        super.complete();
    }
}

