/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.envelope;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class CreateGroupResponse
extends Response {
    private Hash txHash;
    private byte[] privateKey;

    public CreateGroupResponse() {
        super(MessageType.MSG_TYPE_TX_RESP_CREATE_GROUP);
    }

    public Hash getTxHash() {
        return this.txHash;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public byte[] toRlp() {
        byte[] txHashBytes = Rlp.encodeElement(this.txHash.getValue());
        byte[] privateKeyBytes = Rlp.encodeElement(this.privateKey);
        return Rlp.encodeList(super.toRlp(), txHashBytes, privateKeyBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.txHash = new Hash(((RlpElement)list.get(1)).getRlpData());
        this.privateKey = ((RlpElement)list.get(2)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("hash", (Object)ByteUtils.toHexString(this.txHash.getValue()));
        jsonObject.put("group_private_key", (Object)ByteUtils.toHexString(this.privateKey));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.txHash = new Hash(jsonObject.getString("hash"));
        this.privateKey = ByteUtils.hexStringToBytes(jsonObject.getString("group_private_key"));
    }
}

