/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.envelope;

import com.alipay.mychain.sdk.crypto.MyCrypto;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.message.transaction.envelope.GroupTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import java.util.ArrayList;
import java.util.List;

public class DepositEnvelopeRequest
extends GroupTransactionRequest {
    private Identity anonymousIdentity;
    private List<SignerBase> signerBases = new ArrayList<SignerBase>();
    private Keypair keypair;

    public DepositEnvelopeRequest(AbstractTransactionRequest request, BaseFixedSizeByteArray.Fixed20ByteArray groupId, List<SignerBase> signerBases, Keypair keypair) {
        super(MessageType.MSG_TYPE_TX_REQ_DEPOSIT_ENVELOPE, request, groupId);
        this.signerBases = signerBases;
        this.keypair = keypair;
    }

    public DepositEnvelopeRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_DEPOSIT_ENVELOPE);
    }

    @Override
    public boolean isValid() {
        if (this.request == null || this.signerBases == null || this.groupId == null || this.keypair == null) {
            return false;
        }
        return super.isValid();
    }

    public Identity getAnonymousIdentity() {
        return this.anonymousIdentity;
    }

    public void setAnonymousIdentity(Identity anonymousIdentity) {
        this.anonymousIdentity = anonymousIdentity;
        this.request.getTransaction().setFrom(this.anonymousIdentity);
    }

    @Override
    public void setTxTimeNonce(long ts, BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger nonce, boolean force) {
        super.setTxTimeNonce(ts, nonce, force);
        this.getRequest().setTxTimeNonce(ts, nonce, force);
    }

    @Override
    public void complete() {
        if (this.request != null) {
            this.request.setGroupId(this.groupId);
            this.request.complete();
            this.request.getTransaction().setFrom(this.anonymousIdentity);
            this.request.getTransaction().calcSignature(this.signerBases);
        }
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_DEPOSIT_ENVELOP);
        transaction.setGroupId(this.groupId);
        transaction.setFrom(this.getAnonymousIdentity());
        transaction.setData(this.request.toRlp());
        ArrayList<SignerBase> signerBaseList = new ArrayList<SignerBase>();
        signerBaseList.add(MyCrypto.getInstance().createSigner(this.keypair));
        super.complete();
        this.getTransaction().calcSignature(signerBaseList);
    }
}

