/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class ReflectionUtil {
    public static <T> T newInstance(Class<T> theClass, Object ... args) {
        T result;
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Constructor<T> constructor = theClass.getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            result = constructor.newInstance(args);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return null;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        Field field = ReflectionUtil.getDeclaredField(object, fieldName);
        if (field == null) {
            throw new RuntimeException("field is null");
        }
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

