/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.vm.ContractOutput;
import com.alipay.mychain.sdk.vm.EVMABIUtils;
import com.alipay.mychain.sdk.vm.EVMOutput;
import com.alipay.mychain.sdk.vm.EVMParameter;
import com.alipay.mychain.sdk.vm.WASMABIUtils;
import com.alipay.mychain.sdk.vm.WASMOutput;
import com.alipay.mychain.sdk.vm.WASMParameter;
import com.alipay.mychain.sdk.vm.abi.MyTypeDecoder;
import com.alipay.mychain.sdk.vm.abi.datatype.Bool;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes32;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicArray;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.abi.datatype.WASMString;
import com.alipay.mychain.sdk.vm.utils.Utils;
import com.alipay.mychain.sdk.vm.wasm.MyWasmTypeDecoder;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class ABIUtils {
    /*
     * WARNING - void declaration
     */
    public static Parameters buildContractParameter(VMTypeEnum vmTypeEnum, String method, byte[] abiStream, List<Object> args) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InstantiationException, InvocationTargetException {
        if (vmTypeEnum == VMTypeEnum.WASM) {
            void var9_16;
            WASMParameter parameter = new WASMParameter(method);
            Field field = WASMParameter.class.getDeclaredField("inputParameters");
            field.setAccessible(true);
            List inputParameters = (List)field.get(parameter);
            WASMABIUtils.WASMABI wasmabi = (WASMABIUtils.WASMABI)JSON.parseObject((byte[])abiStream, WASMABIUtils.WASMABI.class, (Feature[])new Feature[0]);
            WASMABIUtils.Struct interfaceStruct = null;
            for (WASMABIUtils.Struct struct : wasmabi.getStructs()) {
                if (!struct.getName().equals(method)) continue;
                interfaceStruct = struct;
                break;
            }
            if (interfaceStruct == null) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER);
            }
            boolean bl = false;
            while (var9_16 < interfaceStruct.getFields().size()) {
                if (interfaceStruct.getFields().get((int)var9_16).getType().contains("[]")) {
                    inputParameters.add(new DynamicArray(Utils.typeMap((List)args.get((int)var9_16), WASMABIUtils.classMap.get(interfaceStruct.getFields().get((int)var9_16).getType()))));
                } else {
                    Class destType = WASMABIUtils.classMap.get(interfaceStruct.getFields().get((int)var9_16).getType());
                    Constructor constructor = destType.getDeclaredConstructor(args.get((int)var9_16).getClass());
                    Type t = (Type)constructor.newInstance(args.get((int)var9_16));
                    inputParameters.add(t);
                }
                ++var9_16;
            }
            return parameter;
        }
        if (vmTypeEnum == VMTypeEnum.EVM) {
            List methods = (List)JSONArray.parseObject((byte[])abiStream, List.class, (Feature[])new Feature[0]);
            ArrayList<Object> contractMethods = new ArrayList<Object>();
            for (JSONObject jsonObject : methods) {
                if (!jsonObject.get((Object)"type").equals("function")) continue;
                EVMABIUtils.ContractMethod contractMethod = new EVMABIUtils.ContractMethod();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)jsonObject.get((Object)"name"));
                stringBuilder.append("(");
                List inputs = (List)jsonObject.get((Object)"inputs");
                ArrayList<String> inputTypes = new ArrayList<String>();
                for (JSONObject input : inputs) {
                    inputTypes.add((String)input.get((Object)"type"));
                    stringBuilder.append((String)input.get((Object)"type"));
                    stringBuilder.append(",");
                }
                if (inputs.size() > 0) {
                    stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), ")");
                } else {
                    stringBuilder.append(")");
                }
                contractMethod.setInputTypes(inputTypes);
                List outputs = (List)jsonObject.get((Object)"outputs");
                ArrayList<String> outputTypes = new ArrayList<String>();
                for (JSONObject output : outputs) {
                    outputTypes.add((String)output.get((Object)"type"));
                }
                contractMethod.setOutputTypes(outputTypes);
                contractMethod.setName(stringBuilder.toString());
                contractMethods.add(contractMethod);
            }
            EVMParameter evmParameter = new EVMParameter(method);
            EVMABIUtils.ContractMethod contractMethod = null;
            for (EVMABIUtils.ContractMethod contractMethod2 : contractMethods) {
                if (!contractMethod2.getName().equals(method)) continue;
                contractMethod = contractMethod2;
                break;
            }
            if (contractMethod == null) {
                return evmParameter;
            }
            Field field = EVMParameter.class.getDeclaredField("inputParameters");
            field.setAccessible(true);
            List list = (List)field.get(evmParameter);
            for (int i = 0; i < contractMethod.getInputTypes().size(); ++i) {
                String type = contractMethod.getInputTypes().get(i);
                if (type.contains("[]")) {
                    list.add(new DynamicArray(Utils.typeMap((List)args.get(i), EVMABIUtils.classMap.get(type))));
                    continue;
                }
                Class destType = EVMABIUtils.classMap.get(type);
                Constructor constructor = destType.getDeclaredConstructor(args.get(i).getClass());
                Type t = (Type)constructor.newInstance(args.get(i));
                list.add(t);
            }
            return evmParameter;
        }
        throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER);
    }

    public static List<ContractOutput> getOutput(VMTypeEnum vmTypeEnum, String method, byte[] abiStream, byte[] output) throws UnsupportedEncodingException, IllegalAccessException, NoSuchFieldException, UnsupportedEncodingException {
        if (vmTypeEnum == VMTypeEnum.WASM) {
            WASMOutput wasmOutput = new WASMOutput(Hex.toHexString((byte[])output));
            ArrayList<ContractOutput> contractOutputs = new ArrayList<ContractOutput>();
            WASMABIUtils.WASMABI wasmabi = (WASMABIUtils.WASMABI)JSON.parseObject((byte[])abiStream, WASMABIUtils.WASMABI.class, (Feature[])new Feature[0]);
            WASMABIUtils.Struct interfaceStruct = null;
            for (WASMABIUtils.Struct struct : wasmabi.getStructs()) {
                if (!struct.getName().equals(method)) continue;
                interfaceStruct = struct;
            }
            if (interfaceStruct == null) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER);
            }
            Field rawField = WASMOutput.class.getDeclaredField("rawOutput");
            rawField.setAccessible(true);
            Field offField = WASMOutput.class.getDeclaredField("offset");
            offField.setAccessible(true);
            String rawValue = (String)rawField.get(wasmOutput);
            int offValue = (Integer)offField.get(wasmOutput);
            for (int i = 0; i < interfaceStruct.getResults().size(); ++i) {
                ContractOutput contractOutput = new ContractOutput();
                contractOutput.setType(interfaceStruct.getResults().get(i));
                contractOutput.setValue(new ArrayList<String>());
                if (interfaceStruct.getResults().get(i).contains("[]")) {
                    List<WASMString> wasmStrings;
                    if (interfaceStruct.getResults().get(i).contains("bool")) {
                        List<Boolean> booleans = wasmOutput.getBooleanDynamicArray();
                        for (Boolean boolValue : booleans) {
                            contractOutput.getValue().add(String.valueOf(boolValue));
                        }
                    } else if (interfaceStruct.getResults().get(i).contains("string")) {
                        wasmStrings = wasmOutput.getWasmStringDynamicArray();
                        for (WASMString wasmString : wasmStrings) {
                            contractOutput.getValue().add(new String(wasmString.getValue(), "iso-8859-1"));
                        }
                    } else if (interfaceStruct.getResults().get(i).contains("Identity")) {
                        wasmStrings = wasmOutput.getWasmStringDynamicArray();
                        for (WASMString wasmString : wasmStrings) {
                            contractOutput.getValue().add(new String(wasmString.getValue(), "iso-8859-1"));
                        }
                    } else {
                        List<BigInteger> bigIntegers = wasmOutput.getIntAndUintDynamicArray(WASMABIUtils.classMap.get(interfaceStruct.getResults().get(i)));
                        for (BigInteger bigInteger : bigIntegers) {
                            contractOutput.getValue().add(bigInteger.toString());
                        }
                    }
                } else if (Bool.class.isAssignableFrom(WASMABIUtils.classMap.get(interfaceStruct.getResults().get(i)))) {
                    contractOutput.getValue().add(String.valueOf(wasmOutput.getBoolean()));
                } else if (DynamicBytes.class.isAssignableFrom(WASMABIUtils.classMap.get(interfaceStruct.getResults().get(i)))) {
                    contractOutput.getValue().add(new String(wasmOutput.getBytes(), "iso-8859-1"));
                } else if (WASMString.class.isAssignableFrom(WASMABIUtils.classMap.get(interfaceStruct.getResults().get(i)))) {
                    contractOutput.getValue().add(new String(wasmOutput.getWasmString(), "iso-8859-1"));
                } else if (Bytes32.class.isAssignableFrom(WASMABIUtils.classMap.get(interfaceStruct.getResults().get(i)))) {
                    contractOutput.getValue().add(new String(wasmOutput.getBytes(), "iso-8859-1"));
                } else {
                    Object value = MyWasmTypeDecoder.decodeNumeric(MyWasmTypeDecoder.getDataOffset(rawValue, offValue, WASMABIUtils.classMap.get(interfaceStruct.getResults().get(i))).getRemainData(), WASMABIUtils.classMap.get(interfaceStruct.getResults().get(i)));
                    BigInteger result = (BigInteger)value.getValue();
                    offValue += MyWasmTypeDecoder.getDataOffset(rawValue, offValue, WASMABIUtils.classMap.get(interfaceStruct.getResults().get(i))).getCutString().length();
                    offField.set(wasmOutput, offValue);
                    contractOutput.getValue().add(result.toString());
                }
                contractOutputs.add(contractOutput);
            }
            return contractOutputs;
        }
        if (vmTypeEnum == VMTypeEnum.EVM) {
            EVMOutput evmOutput = new EVMOutput(Hex.toHexString((byte[])output));
            List methods = (List)JSONArray.parseObject((byte[])abiStream, List.class, (Feature[])new Feature[0]);
            EVMABIUtils.ContractMethod findContractMethod = null;
            for (JSONObject jsonObject : methods) {
                if (!jsonObject.get((Object)"type").equals("function")) continue;
                EVMABIUtils.ContractMethod contractMethod = new EVMABIUtils.ContractMethod();
                StringBuilder methodSignature = new StringBuilder();
                methodSignature.append((String)jsonObject.get((Object)"name"));
                methodSignature.append("(");
                List inputs = (List)jsonObject.get((Object)"inputs");
                ArrayList<String> inputTypes = new ArrayList<String>();
                for (JSONObject input : inputs) {
                    inputTypes.add((String)input.get((Object)"type"));
                    methodSignature.append((String)input.get((Object)"type"));
                    methodSignature.append(",");
                }
                if (inputs.size() > 0) {
                    methodSignature.replace(methodSignature.length() - 1, methodSignature.length(), ")");
                } else {
                    methodSignature.append(")");
                }
                contractMethod.setInputTypes(inputTypes);
                List outputArray = (List)jsonObject.get((Object)"outputs");
                ArrayList<String> outputTypes = new ArrayList<String>();
                for (JSONObject outputValue : outputArray) {
                    outputTypes.add((String)outputValue.get((Object)"type"));
                }
                contractMethod.setOutputTypes(outputTypes);
                contractMethod.setName(methodSignature.toString());
                if (!contractMethod.getName().equals(method)) continue;
                findContractMethod = contractMethod;
                break;
            }
            if (findContractMethod == null) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER);
            }
            ArrayList<ContractOutput> contractOutputs = new ArrayList<ContractOutput>();
            Field rawField = EVMOutput.class.getDeclaredField("rawOutput");
            rawField.setAccessible(true);
            Field offField = EVMOutput.class.getDeclaredField("offset");
            offField.setAccessible(true);
            String rawValue = (String)rawField.get(evmOutput);
            int offValue = (Integer)offField.get(evmOutput);
            for (int i = 0; i < findContractMethod.getOutputTypes().size(); ++i) {
                ContractOutput contractOutput = new ContractOutput();
                contractOutput.setType(findContractMethod.getOutputTypes().get(i));
                contractOutput.setValue(new ArrayList<String>());
                if (findContractMethod.getOutputTypes().get(i).contains("[]")) {
                    if (findContractMethod.getOutputTypes().get(i).contains("bool")) {
                        List<Boolean> booleans = evmOutput.getBooleanDynamicArray();
                        for (Boolean boolValue : booleans) {
                            contractOutput.getValue().add(String.valueOf(boolValue));
                        }
                    } else if (findContractMethod.getOutputTypes().get(i).contains("identity")) {
                        List<byte[]> identites = evmOutput.getBytes32DynamicArray();
                        for (byte[] val : identites) {
                            contractOutput.getValue().add(new String(val, "iso-8859-1"));
                        }
                    } else {
                        int hexStringOffset = MyTypeDecoder.getDataOffset(rawValue, offValue, DynamicArray.class);
                        Object outTypes = MyTypeDecoder.decodeDynamicArray(rawValue, hexStringOffset, EVMABIUtils.classMap.get(findContractMethod.getOutputTypes().get(i)));
                        List types = (List)outTypes.getValue();
                        for (Type type : types) {
                            contractOutput.getValue().add(((BigInteger)type.getValue()).toString());
                        }
                        offField.set(evmOutput, offValue += 64);
                    }
                } else if (Bool.class.isAssignableFrom(EVMABIUtils.classMap.get(findContractMethod.getOutputTypes().get(i)))) {
                    contractOutput.getValue().add(String.valueOf(evmOutput.getBoolean()));
                } else if (DynamicBytes.class.isAssignableFrom(EVMABIUtils.classMap.get(findContractMethod.getOutputTypes().get(i)))) {
                    contractOutput.getValue().add(new String(evmOutput.getBytes(), "iso-8859-1"));
                } else if (Utf8String.class.isAssignableFrom(EVMABIUtils.classMap.get(findContractMethod.getOutputTypes().get(i)))) {
                    contractOutput.getValue().add(evmOutput.getString());
                } else if (Bytes32.class.isAssignableFrom(EVMABIUtils.classMap.get(findContractMethod.getOutputTypes().get(i)))) {
                    contractOutput.getValue().add(new String(evmOutput.getBytes32(), "iso-8859-1"));
                } else {
                    Object value = MyTypeDecoder.decodeNumeric(rawValue.substring(MyTypeDecoder.getDataOffset(rawValue, offValue, EVMABIUtils.classMap.get(findContractMethod.getOutputTypes().get(i)))), EVMABIUtils.classMap.get(findContractMethod.getOutputTypes().get(i)));
                    BigInteger result = (BigInteger)value.getValue();
                    offField.set(evmOutput, offValue += 64);
                    contractOutput.getValue().add(result.toString());
                }
                contractOutputs.add(contractOutput);
            }
            return contractOutputs;
        }
        return null;
    }
}

