/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm;

import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.utils.ByteUtils;
import com.alipay.mychain.sdk.vm.abi.datatype.Bool;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes32;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicArray;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Float32;
import com.alipay.mychain.sdk.vm.abi.datatype.Float64;
import com.alipay.mychain.sdk.vm.abi.datatype.Int16;
import com.alipay.mychain.sdk.vm.abi.datatype.Int32;
import com.alipay.mychain.sdk.vm.abi.datatype.Int64;
import com.alipay.mychain.sdk.vm.abi.datatype.Int8;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint16;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint32;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint64;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint8;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.abi.datatype.WASMString;
import com.alipay.mychain.sdk.vm.utils.Utils;
import com.alipay.mychain.sdk.vm.wasm.MyWasmFunctionEncoder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WASMParameter
implements Parameters {
    private String methodSignature;
    private List<Type> inputParameters = new ArrayList<Type>();

    public WASMParameter() {
    }

    public WASMParameter(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    public WASMParameter addInt8(BigInteger value) {
        this.inputParameters.add(new Int8(value));
        return this;
    }

    public WASMParameter addInt16(BigInteger value) {
        this.inputParameters.add(new Int16(value));
        return this;
    }

    public WASMParameter addInt32(BigInteger value) {
        this.inputParameters.add(new Int32(value));
        return this;
    }

    public WASMParameter addInt64(BigInteger value) {
        this.inputParameters.add(new Int64(value));
        return this;
    }

    public WASMParameter addUInt8(BigInteger value) {
        this.inputParameters.add(new Uint8(value));
        return this;
    }

    public WASMParameter addUInt16(BigInteger value) {
        this.inputParameters.add(new Uint16(value));
        return this;
    }

    public WASMParameter addUInt32(BigInteger value) {
        this.inputParameters.add(new Uint32(value));
        return this;
    }

    public WASMParameter addUInt64(BigInteger value) {
        this.inputParameters.add(new Uint64(value));
        return this;
    }

    public WASMParameter addBool(boolean value) {
        this.inputParameters.add(new Bool(value));
        return this;
    }

    public WASMParameter addString(String value) {
        this.inputParameters.add(new Utf8String(value));
        return this;
    }

    public WASMParameter addWASMString(byte[] value) {
        this.inputParameters.add(new WASMString(value));
        return this;
    }

    public WASMParameter addIdentity(Hash hash) {
        this.inputParameters.add(new Bytes32(hash.getValue()));
        return this;
    }

    public WASMParameter addBytes(byte[] value) {
        this.inputParameters.add(new DynamicBytes(value));
        return this;
    }

    public WASMParameter addFloat32(float value) {
        this.inputParameters.add(new Float32(Float.valueOf(value)));
        return this;
    }

    public WASMParameter addFloat64(double value) {
        this.inputParameters.add(new Float64(value));
        return this;
    }

    public WASMParameter addFloat32Array(List<Float> values) {
        this.inputParameters.add(new DynamicArray<Float32>(Utils.typeMap(values, Float32.class)));
        return this;
    }

    public WASMParameter addFloat64Array(List<Double> values) {
        this.inputParameters.add(new DynamicArray<Float64>(Utils.typeMap(values, Float64.class)));
        return this;
    }

    public WASMParameter addInt8Array(List<BigInteger> intValues) {
        this.inputParameters.add(new DynamicArray<Int8>(Utils.typeMap(intValues, Int8.class)));
        return this;
    }

    public WASMParameter addInt16Array(List<BigInteger> intValues) {
        this.inputParameters.add(new DynamicArray<Int16>(Utils.typeMap(intValues, Int16.class)));
        return this;
    }

    public WASMParameter addInt32Array(List<BigInteger> intValues) {
        this.inputParameters.add(new DynamicArray<Int32>(Utils.typeMap(intValues, Int32.class)));
        return this;
    }

    public WASMParameter addInt64Array(List<BigInteger> intValues) {
        this.inputParameters.add(new DynamicArray<Int64>(Utils.typeMap(intValues, Int64.class)));
        return this;
    }

    public WASMParameter addUint8Array(List<BigInteger> uIntValues) {
        this.inputParameters.add(new DynamicArray<Uint8>(Utils.typeMap(uIntValues, Uint8.class)));
        return this;
    }

    public WASMParameter addUint16Array(List<BigInteger> uIntValues) {
        this.inputParameters.add(new DynamicArray<Uint16>(Utils.typeMap(uIntValues, Uint16.class)));
        return this;
    }

    public WASMParameter addUint32Array(List<BigInteger> uIntValues) {
        this.inputParameters.add(new DynamicArray<Uint32>(Utils.typeMap(uIntValues, Uint32.class)));
        return this;
    }

    public WASMParameter addUint64Array(List<BigInteger> uIntValues) {
        this.inputParameters.add(new DynamicArray<Uint64>(Utils.typeMap(uIntValues, Uint64.class)));
        return this;
    }

    public WASMParameter addBooleanArray(List<Boolean> booleans) {
        this.inputParameters.add(new DynamicArray<Bool>(Utils.typeMap(booleans, Bool.class)));
        return this;
    }

    public WASMParameter addUtfStringArray(List<String> strings) {
        this.inputParameters.add(new DynamicArray<Utf8String>(Utils.typeMap(strings, Utf8String.class)));
        return this;
    }

    public WASMParameter addIdentityArray(List<byte[]> identities) {
        this.inputParameters.add(new DynamicArray<Bytes32>(Utils.typeMap(identities, Bytes32.class)));
        return this;
    }

    public String getEncodedData() {
        if (StringUtils.isEmpty((CharSequence)this.methodSignature)) {
            if (this.inputParameters.size() == 0) {
                return "";
            }
            return MyWasmFunctionEncoder.encodeConstructor(this.inputParameters);
        }
        String methodId = MyWasmFunctionEncoder.buildMethodId(this.methodSignature);
        if (this.inputParameters.size() == 0) {
            return methodId;
        }
        StringBuilder result = new StringBuilder();
        result.append(methodId);
        return MyWasmFunctionEncoder.encodeParameters(this.inputParameters, result);
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public void setMethodSignature(String methodSignature) {
        this.methodSignature = methodSignature;
    }

    @Override
    public byte[] getData() {
        return ByteUtils.hexStringToBytes(this.getEncodedData());
    }
}

