/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.Type;

public class Float64
implements Type<Double> {
    private Double value;
    private final String type = "float64";

    public Float64(Double value) {
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public String getTypeAsString() {
        return "float64";
    }

    public boolean equals(Object o) {
        double largest;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Float64 rv = (Float64)o;
        double diff = Math.abs(rv.getValue() - this.getValue());
        double a = Math.abs(rv.getValue());
        double b = Math.abs(rv.getValue().floatValue());
        double d = largest = b > a ? b : a;
        return !(diff > largest * 1.0E-15);
    }

    public int hashCode() {
        int result = "float64".hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

