/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.AbstractIntType;
import java.math.BigInteger;

public class Int16
extends AbstractIntType {
    public static final String TYPE_NAME = "int";
    public static final BigInteger MAX_INT16 = BigInteger.valueOf(32767L);
    public static final BigInteger MIN_INT16 = BigInteger.valueOf(-32768L);
    public static final Int16 DEFAULT = new Int16(BigInteger.ZERO);
    public static final int BYTE_LENGTH = 2;

    public Int16(BigInteger value) {
        this(16, value);
    }

    public Int16(long value) {
        this(BigInteger.valueOf(value));
    }

    public Int16(Int16 value) {
        this(value.getValue());
    }

    protected Int16(int bitSize, BigInteger value) {
        super(TYPE_NAME, bitSize, value);
        if (value.compareTo(MAX_INT16) > 0 || value.compareTo(MIN_INT16) < 0) {
            throw new UnsupportedOperationException("Int16 should not be greater than 32767 and less than -32768");
        }
    }
}

