/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.AbstractIntType;
import java.math.BigInteger;

public class Int32
extends AbstractIntType {
    public static final String TYPE_NAME = "int";
    public static final BigInteger MAX_INT32 = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger MIN_INT32 = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final Int32 DEFAULT = new Int32(BigInteger.ZERO);
    public static final int BYTE_LENGTH = 4;

    public Int32(BigInteger value) {
        this(32, value);
    }

    public Int32(long value) {
        this(BigInteger.valueOf(value));
    }

    public Int32(Int32 value) {
        this(value.getValue());
    }

    protected Int32(int bitSize, BigInteger value) {
        super(TYPE_NAME, bitSize, value);
        if (value.compareTo(MAX_INT32) > 0 || value.compareTo(MIN_INT32) < 0) {
            throw new UnsupportedOperationException("Int32 should not be greater than 2147483647 and less than -2147483648");
        }
    }
}

