/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.wasm;

import com.alipay.mychain.sdk.vm.abi.datatype.AbstractArray;
import com.alipay.mychain.sdk.vm.abi.datatype.AbstractNumericType;
import com.alipay.mychain.sdk.vm.abi.datatype.Bool;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes;
import com.alipay.mychain.sdk.vm.abi.datatype.BytesType;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicArray;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Float32;
import com.alipay.mychain.sdk.vm.abi.datatype.Float64;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Ufixed;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.abi.datatype.WASMString;
import com.alipay.mychain.sdk.vm.utils.Numeric;
import com.alipay.mychain.sdk.vm.wasm.Leb128Utils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;

public class MyWasmTypeEncoder {
    private MyWasmTypeEncoder() {
    }

    static boolean isDynamic(Type parameter) {
        return parameter instanceof DynamicBytes || parameter instanceof Utf8String || parameter instanceof DynamicArray || parameter instanceof WASMString;
    }

    public static String encode(Type parameter) {
        if (parameter instanceof AbstractNumericType) {
            return MyWasmTypeEncoder.encodeNumeric((AbstractNumericType)parameter);
        }
        if (parameter instanceof Float32) {
            return MyWasmTypeEncoder.encodeFloat32((Float32)parameter);
        }
        if (parameter instanceof Float64) {
            return MyWasmTypeEncoder.encodeFloat64((Float64)parameter);
        }
        if (parameter instanceof Bool) {
            return MyWasmTypeEncoder.encodeBool((Bool)parameter);
        }
        if (parameter instanceof Bytes) {
            return MyWasmTypeEncoder.encodeBytes((Bytes)parameter);
        }
        if (parameter instanceof DynamicBytes) {
            return MyWasmTypeEncoder.encodeDynamicBytes((DynamicBytes)parameter);
        }
        if (parameter instanceof Utf8String) {
            return MyWasmTypeEncoder.encodeString((Utf8String)parameter);
        }
        if (parameter instanceof WASMString) {
            return MyWasmTypeEncoder.encodeWasmString((WASMString)parameter);
        }
        if (parameter instanceof DynamicArray) {
            return MyWasmTypeEncoder.encodeDynamicArray((DynamicArray)parameter);
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + parameter.getClass());
    }

    public static String encodeFloat32(Float32 value) {
        int bits = Float.floatToRawIntBits(value.getValue().floatValue());
        byte[] bytes = new byte[]{(byte)(bits & 0xFF), (byte)(bits >> 8 & 0xFF), (byte)(bits >> 16 & 0xFF), (byte)(bits >>> 24 & 0xFF)};
        return Numeric.toHexStringNoPrefix(bytes);
    }

    public static String encodeFloat64(Float64 value) {
        long bits = Double.doubleToRawLongBits(value.getValue());
        byte[] bytes = new byte[]{(byte)(bits & 0xFFL), (byte)(bits >> 8 & 0xFFL), (byte)(bits >> 16 & 0xFFL), (byte)(bits >> 24 & 0xFFL), (byte)(bits >> 32 & 0xFFL), (byte)(bits >> 40 & 0xFFL), (byte)(bits >> 48 & 0xFFL), (byte)(bits >> 56 & 0xFFL)};
        return Numeric.toHexStringNoPrefix(bytes);
    }

    static String encodeNumeric(AbstractNumericType numericType) {
        byte[] rawValue = MyWasmTypeEncoder.toByteArray(numericType, numericType.getByteLength());
        return Numeric.toHexStringNoPrefix(rawValue);
    }

    private static byte getPaddingValue(AbstractNumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(AbstractNumericType numericType, int length) {
        BigInteger value = numericType.getValue();
        if (numericType instanceof Uint) {
            byte[] byteArray = new byte[length];
            byte[] rawValue = value.toByteArray();
            ArrayUtils.reverse((byte[])rawValue);
            int minLength = length <= rawValue.length ? length : rawValue.length;
            System.arraycopy(rawValue, 0, byteArray, 0, minLength);
            return byteArray;
        }
        if (numericType instanceof Ufixed && value.bitLength() == 256) {
            byte[] byteArray = new byte[256];
            byte[] rawValue = value.toByteArray();
            ArrayUtils.reverse((byte[])rawValue);
            System.arraycopy(rawValue, 1, byteArray, 0, 256);
            return byteArray;
        }
        if (numericType.getValue().signum() >= 0) {
            byte[] byteArray = new byte[length];
            byte[] rawValue = value.toByteArray();
            ArrayUtils.reverse((byte[])rawValue);
            int minLength = length <= rawValue.length ? length : rawValue.length;
            System.arraycopy(rawValue, 0, byteArray, 0, minLength);
            return byteArray;
        }
        byte[] byteArray = new byte[length];
        byte[] rawValue = value.toByteArray();
        ArrayUtils.reverse((byte[])rawValue);
        System.arraycopy(rawValue, 0, byteArray, 0, rawValue.length);
        for (int i = rawValue.length; i < byteArray.length; ++i) {
            byteArray[i] = -1;
        }
        return byteArray;
    }

    static String encodeBool(Bool value) {
        byte[] rawValue = new byte[1];
        if (value.getValue().booleanValue()) {
            rawValue[0] = 1;
        }
        return Numeric.toHexStringNoPrefix(rawValue);
    }

    static String encodeBytes(BytesType bytesType) {
        int size = bytesType.getValue().length;
        String encodedLength = Leb128Utils.leb128HexString(size);
        String encodedValue = MyWasmTypeEncoder.encodePureBytes(bytesType);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValue);
        return result.toString();
    }

    static String encodeWasmString(WASMString string) {
        return MyWasmTypeEncoder.encodeDynamicBytes(new DynamicBytes(string.getValue()));
    }

    static String encodePureBytes(BytesType bytesType) {
        byte[] value = bytesType.getValue();
        return Numeric.toHexStringNoPrefix(value);
    }

    static String encodeDynamicBytes(DynamicBytes dynamicBytes) {
        int size = dynamicBytes.getValue().length;
        String encodedLength = Leb128Utils.leb128HexString(size);
        String encodedValue = MyWasmTypeEncoder.encodePureBytes(dynamicBytes);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValue);
        return result.toString();
    }

    static String encodeString(Utf8String string) {
        byte[] utfEncoded = string.getValue().getBytes(StandardCharsets.UTF_8);
        return MyWasmTypeEncoder.encodeDynamicBytes(new DynamicBytes(utfEncoded));
    }

    static <T extends Type> String encodeArrayValues(AbstractArray<T> value) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = value.getValue().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            result.append(MyWasmTypeEncoder.encode(type));
        }
        return result.toString();
    }

    static <T extends Type> String encodeDynamicArray(DynamicArray<T> value) {
        int size = value.getValue().size();
        String encodedLength = Leb128Utils.leb128HexString(size);
        String encodedValues = MyWasmTypeEncoder.encodeArrayValues(value);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValues);
        return result.toString();
    }
}

