/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.api.callback.IEventCallback;
import com.alipay.mychain.sdk.api.utils.Utils;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.crypto.MyCrypto;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.account.Account;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.vm.EVMOutput;
import com.alipay.mychain.sdk.vm.NativeCallParameters;
import com.alipay.mychain.sdk.vm.WASMOutput;
import com.antfinancial.mychain.baas.tool.restclient.RestClientProperties;
import com.antfinancial.mychain.baas.tool.restclient.cccs.CccsAdminRequest;
import com.antfinancial.mychain.baas.tool.restclient.client.RestHttpClient;
import com.antfinancial.mychain.baas.tool.restclient.model.AccountRequest;
import com.antfinancial.mychain.baas.tool.restclient.model.BlockchainConfig;
import com.antfinancial.mychain.baas.tool.restclient.model.CallRestBizParam;
import com.antfinancial.mychain.baas.tool.restclient.model.CallRestParam;
import com.antfinancial.mychain.baas.tool.restclient.model.ClientParam;
import com.antfinancial.mychain.baas.tool.restclient.model.CodeAuditParam;
import com.antfinancial.mychain.baas.tool.restclient.model.FreezeAccountWithSignature;
import com.antfinancial.mychain.baas.tool.restclient.model.Method;
import com.antfinancial.mychain.baas.tool.restclient.model.QueryBlockHeaderInfosRequest;
import com.antfinancial.mychain.baas.tool.restclient.model.ReceiptDecoration;
import com.antfinancial.mychain.baas.tool.restclient.model.RestClientReliableEventTask;
import com.antfinancial.mychain.baas.tool.restclient.model.ShakeRequest;
import com.antfinancial.mychain.baas.tool.restclient.model.SyncTenantTPSRequest;
import com.antfinancial.mychain.baas.tool.restclient.model.UnFreezeAccountWithSignature;
import com.antfinancial.mychain.baas.tool.restclient.request.ConstructCallContractRequest;
import com.antfinancial.mychain.baas.tool.restclient.request.ConstructDeployContractRequest;
import com.antfinancial.mychain.baas.tool.restclient.request.ConstructDepositRequest;
import com.antfinancial.mychain.baas.tool.restclient.request.UpdateContractRequestBuilder;
import com.antfinancial.mychain.baas.tool.restclient.response.BaseResp;
import com.antfinancial.mychain.baas.tool.restclient.response.BlockHeaderInfoResp;
import com.antfinancial.mychain.baas.tool.restclient.task.TimerTaskManager;
import com.antfinancial.mychain.baas.tool.restclient.utils.CertUtil;
import com.antfinancial.mychain.baas.tool.restclient.utils.CheckBizParam;
import com.antfinancial.mychain.baas.tool.restclient.utils.OssUtil;
import com.antfinancial.mychain.baas.tool.utils.AESUtils;
import com.antfinancial.mychain.baas.tool.utils.ContractParameterUtils;
import com.antfinancial.mychain.baas.tool.utils.WasmParaType;
import com.antfinancial.mychain.baas.tool.utils.WasmParaUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

public class RestClient {
    private static final String CONTENT_TYPE = "application/json;charset=utf-8";
    private static final Logger logger;
    private static TimerTaskManager timerTaskManager;
    private RestTemplate restTemplate;
    private RestClientProperties restClientProperties;
    private List<SignerBase> signerBases;
    private String accessSecret;
    private volatile String restToken;
    @Autowired
    public RetryTemplate retryTemplate;
    private OssUtil ossUtil;
    private final String shakeUrl;
    private final String chainCallUrl;
    private final String chainCallBizUrl;
    private final String contractAuditUrl;
    @Autowired
    private RestHttpClient httpClient;

    public RestClient(RestTemplate restTemplate, RestClientProperties restClientProperties) throws IOException {
        this.restTemplate = restTemplate;
        this.restClientProperties = restClientProperties;
        if (!StringUtils.isEmpty((CharSequence)restClientProperties.getDefaultAccountKey()) && !StringUtils.isEmpty((CharSequence)restClientProperties.getDefaultAccountPwd())) {
            try {
                byte[] privateKeyBuf = this.readFromMultiSource(restClientProperties.getDefaultAccountKey());
                Keypair keypair = new Pkcs8KeyOperator().load(privateKeyBuf, restClientProperties.getDefaultAccountPwd());
                SignerBase signerBase = MyCrypto.getInstance().createSigner(keypair);
                this.signerBases = Arrays.asList(signerBase);
            }
            catch (Exception e) {
                logger.warn("init rest client error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        this.shakeUrl = restClientProperties.getRestUrl() + "/api/contract/shakeHand";
        this.chainCallUrl = restClientProperties.getRestUrl() + "/api/contract/chainCall";
        this.chainCallBizUrl = restClientProperties.getRestUrl() + "/api/contract/chainCallForBiz";
        this.contractAuditUrl = restClientProperties.getRestUrl() + "/api/contract/codeAudit";
    }

    private byte[] readFromInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        int length = 0;
        while ((length = inputStream.read(buf)) >= 0) {
            byteArrayOutputStream.write(buf, 0, length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] readFromMultiSource(String name) throws IOException {
        InputStream inputStream = this.restClientProperties.getReadFileFromExt() == false ? RestClient.class.getClassLoader().getResourceAsStream(name) : new FileInputStream(name);
        return this.readFromInputStream(inputStream);
    }

    private void shake() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("start shake hand");
        }
        long now = System.currentTimeMillis();
        String secret = CertUtil.sign(this.restClientProperties.getAccessId() + now, this.accessSecret);
        ShakeRequest shakeRequest = ShakeRequest.builder().accessId(this.restClientProperties.getAccessId()).time(now + "").secret(secret).build();
        BaseResp resp = this.getHttpClient().callBaaSRest(this.shakeUrl, CONTENT_TYPE, shakeRequest, this.restTemplate);
        String string = this.restToken = resp.getCode().equals("200") ? resp.getData() : this.restToken;
        if (logger.isInfoEnabled()) {
            logger.info("new rest token:" + this.restToken);
        }
    }

    @PostConstruct
    public void init() throws Exception {
        this.accessSecret = new String(this.readFromMultiSource(this.restClientProperties.getAccessSecret()));
        this.shake();
    }

    public String createUpdateEventTopicRequestStr(String eventId, String blockNumStr, boolean forceUpdate) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("eventId", (Object)eventId);
        jsonObject.put("blockNumStr", (Object)blockNumStr);
        jsonObject.put("forceUpdate", (Object)forceUpdate);
        return jsonObject.toJSONString();
    }

    public ClientParam createDepositTransaction(@NonNull String account, @NonNull String content) throws Exception {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        return this.createDepositTransaction(account, content, 0L);
    }

    public ClientParam createDepositTransaction(@NonNull String account, @NonNull String content, Long gas) throws Exception {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        return new ConstructDepositRequest().createDepositTransaction(Utils.getIdentityByName(account), content.getBytes("utf-8"), gas, this.signerBases);
    }

    public ClientParam createCallContractTransaction(@NonNull String account, @NonNull String contractName, String outTypes, @NonNull String methodSignature, @NonNull String inputParamListStr, Boolean isLocalTransaction, BigInteger blockNumber) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (methodSignature == null) {
            throw new NullPointerException("methodSignature");
        }
        if (inputParamListStr == null) {
            throw new NullPointerException("inputParamListStr");
        }
        return this.createCallContractTransaction(account, contractName, outTypes, methodSignature, inputParamListStr, isLocalTransaction, blockNumber, 0L);
    }

    public String createBlockchainConfigRequestStr(@NonNull String propValue, @NonNull String source, @NonNull int version) {
        if (propValue == null) {
            throw new NullPointerException("propValue");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        BlockchainConfig config = BlockchainConfig.builder().propValue(propValue).source(source).version(version).build();
        return JSON.toJSONString((Object)config);
    }

    public String createSyncTenantMaxTPSStr(@NonNull String tenantId, @NonNull long maxTPS) {
        if (tenantId == null) {
            throw new NullPointerException("tenantId");
        }
        SyncTenantTPSRequest request = SyncTenantTPSRequest.builder().tenantId(tenantId).maxTPS(maxTPS).build();
        return JSON.toJSONString((Object)request);
    }

    public ClientParam createCallContractTransaction(@NonNull String account, @NonNull String contractName, String outTypes, @NonNull String methodSignature, @NonNull String inputParamListStr, Boolean isLocalTransaction, BigInteger blockNumber, Long gas) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (methodSignature == null) {
            throw new NullPointerException("methodSignature");
        }
        if (inputParamListStr == null) {
            throw new NullPointerException("inputParamListStr");
        }
        return new ConstructCallContractRequest().createCallContractTransaction(Utils.getIdentityByName(account), Utils.getIdentityByName(contractName), outTypes, methodSignature, inputParamListStr, isLocalTransaction, blockNumber, gas, this.signerBases, VMTypeEnum.EVM, null, null, null);
    }

    public ClientParam createCallWasmContractTransaction(@NonNull String account, @NonNull String contractName, String outTypes, @NonNull String methodSignature, @NonNull String inputParamStr, Boolean isLocalTransaction, BigInteger blockNumber) throws Exception {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (methodSignature == null) {
            throw new NullPointerException("methodSignature");
        }
        if (inputParamStr == null) {
            throw new NullPointerException("inputParamStr");
        }
        return this.createCallWasmContractTransaction(account, contractName, outTypes, methodSignature, inputParamStr, isLocalTransaction, blockNumber, 0L);
    }

    public ClientParam createCallWasmContractTransaction(@NonNull String account, @NonNull String contractName, String outTypes, @NonNull String methodSignature, @NonNull String inputParamStr, Boolean isLocalTransaction, BigInteger blockNumber, Long gas) throws Exception {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (methodSignature == null) {
            throw new NullPointerException("methodSignature");
        }
        if (inputParamStr == null) {
            throw new NullPointerException("inputParamStr");
        }
        return new ConstructCallContractRequest().createCallContractTransaction(Utils.getIdentityByName(account), Utils.getIdentityByName(contractName), outTypes, methodSignature, inputParamStr, isLocalTransaction, blockNumber, gas, this.signerBases, VMTypeEnum.WASM, null, null, null);
    }

    public ClientParam createCallWasmContractTransactionEncrypt(@NonNull String account, @NonNull String contractName, String outTypes, @NonNull String methodSignature, @NonNull String inputParamStr, Boolean isLocalTransaction, BigInteger blockNumber, String teePublicKey, String secretKey) throws Exception {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (methodSignature == null) {
            throw new NullPointerException("methodSignature");
        }
        if (inputParamStr == null) {
            throw new NullPointerException("inputParamStr");
        }
        return new ConstructCallContractRequest().createCallContractTransaction(Utils.getIdentityByName(account), Utils.getIdentityByName(contractName), outTypes, methodSignature, inputParamStr, isLocalTransaction, blockNumber, 0L, this.signerBases, VMTypeEnum.WASM, null, teePublicKey, secretKey);
    }

    public ClientParam createCallWasmContractTransactionEncrypt(@NonNull String account, @NonNull String contractName, String outTypes, @NonNull String methodSignature, @NonNull String inputParamStr, Boolean isLocalTransaction, BigInteger blockNumber, Long gas, String teePublicKey, String secretKey) throws Exception {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (methodSignature == null) {
            throw new NullPointerException("methodSignature");
        }
        if (inputParamStr == null) {
            throw new NullPointerException("inputParamStr");
        }
        return new ConstructCallContractRequest().createCallContractTransaction(Utils.getIdentityByName(account), Utils.getIdentityByName(contractName), outTypes, methodSignature, inputParamStr, isLocalTransaction, blockNumber, gas, this.signerBases, VMTypeEnum.WASM, null, teePublicKey, secretKey);
    }

    public ClientParam createCallNativeContractTransaction(@NonNull String account, @NonNull String contractName, @NonNull byte[] parameterData, Boolean isLocalTransaction, BigInteger blockNumber) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (parameterData == null) {
            throw new NullPointerException("parameterData");
        }
        return this.createCallNativeContractTransaction(account, contractName, parameterData, isLocalTransaction, blockNumber, 0L);
    }

    public ClientParam createCallNativeContractTransaction(@NonNull String account, @NonNull String contractName, @NonNull byte[] parameterData, Boolean isLocalTransaction, BigInteger blockNumber, Long gas) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (parameterData == null) {
            throw new NullPointerException("parameterData");
        }
        NativeCallParameters parameters = new NativeCallParameters();
        parameters.setData(parameterData);
        return new ConstructCallContractRequest().createCallContractTransaction(Utils.getIdentityByName(account), Utils.getIdentityByName(contractName), "", null, null, isLocalTransaction, blockNumber, gas, this.signerBases, VMTypeEnum.NATIVE, parameters, "", "");
    }

    public ClientParam createCallNativeContractTransaction(@NonNull String account, @NonNull String contractName, @NonNull String methodSignature, @NonNull String nativeContractData, Boolean isLocalTransaction, BigInteger blockNumber) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (methodSignature == null) {
            throw new NullPointerException("methodSignature");
        }
        if (nativeContractData == null) {
            throw new NullPointerException("nativeContractData");
        }
        return this.createCallNativeContractTransaction(account, contractName, methodSignature, nativeContractData, isLocalTransaction, blockNumber, 0L);
    }

    public ClientParam createCallNativeContractTransaction(@NonNull String account, @NonNull String contractName, @NonNull String methodSignature, @NonNull String nativeContractData, Boolean isLocalTransaction, BigInteger blockNumber, Long gas) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (methodSignature == null) {
            throw new NullPointerException("methodSignature");
        }
        if (nativeContractData == null) {
            throw new NullPointerException("nativeContractData");
        }
        return new ConstructCallContractRequest().createCallContractTransaction(Utils.getIdentityByName(account), Utils.getIdentityByName(contractName), "", methodSignature, nativeContractData, isLocalTransaction, blockNumber, gas, this.signerBases, VMTypeEnum.NATIVE, null, "", "");
    }

    public ClientParam createDeployContractTransaction(@NonNull String account, @NonNull String contractName, @NonNull byte[] code, VMTypeEnum vmTypeEnum) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (code == null) {
            throw new NullPointerException("code");
        }
        return this.createDeployContractTransaction(account, contractName, code, vmTypeEnum, 0L);
    }

    public ClientParam createDeployContractTransaction(@NonNull String account, @NonNull String contractName, @NonNull byte[] code, VMTypeEnum vmTypeEnum, Long gas) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (code == null) {
            throw new NullPointerException("code");
        }
        return new ConstructDeployContractRequest().createDeployContractTransaction(Utils.getIdentityByName(account), Utils.getIdentityByName(contractName), code, vmTypeEnum, gas, this.signerBases, null);
    }

    public ClientParam createDeployContractTransaction(@NonNull String account, @NonNull String contractName, @NonNull byte[] code, VMTypeEnum vmTypeEnum, Long gas, String secretKey) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (code == null) {
            throw new NullPointerException("code");
        }
        return new ConstructDeployContractRequest().createDeployContractTransaction(Utils.getIdentityByName(account), Utils.getIdentityByName(contractName), code, vmTypeEnum, gas, this.signerBases, secretKey);
    }

    public ClientParam createUpdateContractTransaction(@NonNull String account, @NonNull String contractName, @NonNull byte[] code, VMTypeEnum vmTypeEnum, Long gas, String secretKey) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        if (contractName == null) {
            throw new NullPointerException("contractName");
        }
        if (code == null) {
            throw new NullPointerException("code");
        }
        return UpdateContractRequestBuilder.createUpdateContractTransaction(account, contractName, code, vmTypeEnum, gas, this.signerBases, secretKey);
    }

    public ClientParam createFreezeAccountTransaction(String account, @NonNull String freezeAccount) throws Exception {
        if (freezeAccount == null) {
            throw new NullPointerException("freezeAccount");
        }
        FreezeAccountWithSignature freezeAccountWithSignature = new FreezeAccountWithSignature();
        freezeAccountWithSignature.setFrom(account);
        freezeAccountWithSignature.setTo(freezeAccount);
        ClientParam clientCallContractParam = new ClientParam();
        clientCallContractParam.setHash("");
        clientCallContractParam.setSignData(JSON.toJSONString((Object)freezeAccountWithSignature));
        return clientCallContractParam;
    }

    public ClientParam createUnFreezeAccountTransaction(String account, @NonNull String unFreezeAccount) {
        if (unFreezeAccount == null) {
            throw new NullPointerException("unFreezeAccount");
        }
        UnFreezeAccountWithSignature unFreezeAccountWithSignature = new UnFreezeAccountWithSignature();
        unFreezeAccountWithSignature.setFrom(account);
        unFreezeAccountWithSignature.setTo(unFreezeAccount);
        ClientParam clientCallContractParam = new ClientParam();
        clientCallContractParam.setHash("");
        clientCallContractParam.setSignData(JSON.toJSONString((Object)unFreezeAccountWithSignature));
        return clientCallContractParam;
    }

    public ClientParam createQueryAccountParam(@NonNull String queryAccount) {
        if (queryAccount == null) {
            throw new NullPointerException("queryAccount");
        }
        AccountRequest queryAccountRequest = new AccountRequest();
        queryAccountRequest.setQueryAccount(queryAccount);
        ClientParam queryAccountParam = new ClientParam();
        queryAccountParam.setSignData(JSON.toJSONString((Object)queryAccountRequest));
        return queryAccountParam;
    }

    public AccountRequest createQueryAccountForBiz(String queryAccount) {
        AccountRequest queryAccountRequest = new AccountRequest();
        queryAccountRequest.setQueryAccount(queryAccount);
        return queryAccountRequest;
    }

    public String createQUeryBlockHeaderInfosRequestStr(String blockNumber, String hash, @NonNull String maxAmount, String reverse) {
        if (maxAmount == null) {
            throw new NullPointerException("maxAmount");
        }
        QueryBlockHeaderInfosRequest request = new QueryBlockHeaderInfosRequest();
        request.setBlockNumber(blockNumber);
        request.setHash(hash);
        request.setMaxAmount(maxAmount);
        request.setReverse(reverse);
        return JSON.toJSONString((Object)request);
    }

    public BaseResp chainCall(String hash, String requestStr, Method method) throws Exception {
        return this.chainCall(hash, this.restClientProperties.getBizid(), requestStr, method);
    }

    public BaseResp chainCall(String hash, String requestStr, Method method, String gasAccount) throws Exception {
        return this.chainCall(hash, this.restClientProperties.getBizid(), requestStr, method, gasAccount);
    }

    public BaseResp chainCall(String hash, @NonNull String bizid, String requestStr, @NonNull Method method) throws Exception {
        if (bizid == null) {
            throw new NullPointerException("bizid");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        return this.chainCall(hash, bizid, requestStr, method, null);
    }

    public BaseResp chainCall(String hash, @NonNull String bizid, String requestStr, @NonNull Method method, String gasAccount) throws Exception {
        if (bizid == null) {
            throw new NullPointerException("bizid");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        CallRestParam callRestParam = CallRestParam.builder().accessId(this.restClientProperties.getAccessId()).hash(hash).bizid(bizid).token(this.restToken).requestStr(requestStr).method(method).gasAccount(gasAccount).build();
        return this.chainCall(callRestParam);
    }

    public BaseResp chainCall(final CallRestParam callRestParam) throws Exception {
        callRestParam.setAccessId(this.restClientProperties.getAccessId());
        callRestParam.setToken(this.restToken);
        if (StringUtils.isEmpty((CharSequence)callRestParam.getBizid())) {
            callRestParam.setBizid(this.restClientProperties.getBizid());
        }
        final AtomicInteger retryTimes = new AtomicInteger(0);
        return (BaseResp)this.retryTemplate.execute((RetryCallback)new RetryCallback<Object, Exception>(){

            public Object doWithRetry(RetryContext context) throws Exception {
                BaseResp baseResp = RestClient.this.getHttpClient().callBaaSRest(RestClient.this.chainCallUrl, RestClient.CONTENT_TYPE, callRestParam, RestClient.this.restTemplate);
                if (!baseResp.isSuccess()) {
                    if (baseResp.getCode().equals("202")) {
                        RestClient.this.shake();
                        callRestParam.setToken(RestClient.this.restToken);
                    }
                    if ((baseResp.getCode().equals("202") || baseResp.getCode().startsWith("5")) && retryTimes.incrementAndGet() < RestClient.this.restClientProperties.getRetryMaxAttempts()) {
                        throw new RuntimeException("rest errorCode:[" + baseResp.getCode() + ",errMsg:" + baseResp.getData() + "]");
                    }
                }
                return baseResp;
            }
        });
    }

    public BaseResp contractAudit(String orderId, String code, String entryPoint, String staticAnalysisTypeStr, Method method) throws Exception {
        final CodeAuditParam param = new CodeAuditParam();
        param.orderId = orderId;
        param.code = code;
        param.entryPoint = entryPoint;
        param.method = method;
        param.staticAnalysisType = staticAnalysisTypeStr;
        return (BaseResp)this.retryTemplate.execute((RetryCallback)new RetryCallback<Object, Exception>(){

            public Object doWithRetry(RetryContext context) throws Exception {
                BaseResp baseResp = RestClient.this.getHttpClient().callBaaSRest(RestClient.this.contractAuditUrl, RestClient.CONTENT_TYPE, param, RestClient.this.restTemplate);
                if (!baseResp.isSuccess()) {
                    if (baseResp.getCode().equals("202")) {
                        RestClient.this.shake();
                        param.setToken(RestClient.this.restToken);
                    }
                    if (baseResp.getCode().equals("202") || baseResp.getCode().startsWith("5")) {
                        throw new RuntimeException("rest errorCode:[" + baseResp.getCode() + ",errMsg:" + baseResp.getData() + "]");
                    }
                }
                return baseResp;
            }
        });
    }

    public BlockHeaderInfoResp chainCallRawBlockHeaderInfo(String hash, @NonNull String bizid, String requestStr, @NonNull Method method) throws Exception {
        if (bizid == null) {
            throw new NullPointerException("bizid");
        }
        if (method == null) {
            throw new NullPointerException("method");
        }
        BaseResp baseResp = this.chainCall(hash, bizid, requestStr, method);
        BlockHeaderInfoResp resp = new BlockHeaderInfoResp();
        resp.setSuccess(baseResp.isSuccess());
        resp.setCode(baseResp.getCode());
        resp.setRawData(Base64.decodeBase64((String)baseResp.getData()));
        return resp;
    }

    public BaseResp multipleQueryReceipt(final String bizid, final String hash) throws Exception {
        final AtomicInteger retryTimes = new AtomicInteger(0);
        return (BaseResp)this.retryTemplate.execute((RetryCallback)new RetryCallback<Object, Exception>(){

            public Object doWithRetry(RetryContext retryContext) throws Exception {
                BaseResp baseResp = RestClient.this.chainCall(hash, bizid, "", Method.QUERYRECEIPT);
                if (!baseResp.isSuccess() && (String.valueOf(ErrorCode.SERVICE_TX_WAITING_VERIFY.getErrorCode()).equals(baseResp.getCode()) || String.valueOf(ErrorCode.SERVICE_TX_WAITING_EXECUTE.getErrorCode()).equals(baseResp.getCode()) || String.valueOf(ErrorCode.SERVICE_QUERY_NO_RESULT.getErrorCode()).equals(baseResp.getCode()) || String.valueOf(ErrorCode.SERVICE_FORWARD_QUERY_NO_RESULT.getErrorCode()).equals(baseResp.getCode()) || baseResp.getCode().startsWith("5")) && retryTimes.incrementAndGet() < RestClient.this.restClientProperties.getRetryMaxAttempts()) {
                    throw new RuntimeException("queryreceipt errorCode:[" + baseResp.getCode() + "] msg[" + baseResp.getData() + "]");
                }
                try {
                    ReceiptDecoration receipt = (ReceiptDecoration)JSON.parseObject((String)baseResp.getData(), ReceiptDecoration.class);
                    receipt.setHash(hash);
                    baseResp.setData(JSON.toJSONString((Object)receipt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return baseResp;
            }
        });
    }

    public BaseResp callWasmContractSync(String bizid, String hash, String requestStr, String outputTypes) throws Exception {
        this.chainCall(hash, requestStr, Method.CALLWASMCONTRACT);
        BaseResp baseResp = this.multipleQueryReceipt(bizid, hash);
        TransactionReceipt transactionReceipt = (TransactionReceipt)JSON.parseObject((String)baseResp.getData(), TransactionReceipt.class);
        WASMOutput wasmContractReturnValues = new WASMOutput(Hex.toHexString((byte[])transactionReceipt.getOutput()));
        String returnTypeStr = outputTypes.replace("[", "").replace("]", "");
        String[] returnTypes = returnTypeStr.length() > 0 ? returnTypeStr.split(",") : new String[]{};
        List<Object> returnValues = WasmParaUtils.getWasmReturnValues(wasmContractReturnValues, returnTypes);
        return BaseResp.builder().success(true).code("200").data(JSON.toJSONString(returnValues)).build();
    }

    public BaseResp callWasmContractAsyncWithReceipt(CallRestBizParam callRestBizParam) throws Exception {
        BaseResp callResp = this.chainCallForBiz(callRestBizParam);
        if (!callResp.isSuccess() || !callResp.getCode().equals("200")) {
            return callResp;
        }
        BaseResp baseResp = this.multipleQueryReceipt(callRestBizParam.getBizid(), callResp.getData());
        TransactionReceipt transactionReceipt = (TransactionReceipt)JSON.parseObject((String)baseResp.getData(), TransactionReceipt.class);
        WASMOutput wasmContractReturnValues = new WASMOutput(Hex.toHexString((byte[])transactionReceipt.getOutput()));
        List output = JSONArray.parseArray((String)callRestBizParam.getOutTypes(), String.class);
        String[] returnTypes = new String[output.size()];
        for (int i = 0; i < output.size(); ++i) {
            returnTypes[i] = (String)output.get(i);
        }
        List<Object> outRes = null;
        if (output.size() > 0) {
            if (ArrayUtils.isEmpty((byte[])transactionReceipt.getOutput()) && !"void".equals(output.get(0))) {
                return BaseResp.builder().success(true).code("400").data("tx:" + callResp.getData() + ",function has no any output!").build();
            }
            outRes = WasmParaUtils.getWasmReturnValues(wasmContractReturnValues, returnTypes);
        }
        return BaseResp.builder().success(true).code("200").data(JSON.toJSONString(outRes)).build();
    }

    private BaseResp getRespByReceipt(BaseResp baseResp, String txHash) {
        HashMap res = new HashMap();
        ReceiptDecoration receiptDecoration = (ReceiptDecoration)JSON.parseObject((String)baseResp.getData(), ReceiptDecoration.class);
        HashMap<String, Object> mychainBaseResult = new HashMap<String, Object>();
        mychainBaseResult.put("success", baseResp.isSuccess());
        mychainBaseResult.put("txHash", txHash);
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("success", Boolean.valueOf(baseResp.isSuccess()));
        HashMap<String, Object> transactionReceipt = new HashMap<String, Object>();
        transactionReceipt.put("output", receiptDecoration.getOutput());
        transactionReceipt.put("result", receiptDecoration.getResult());
        transactionReceipt.put("gasUsed", receiptDecoration.getGasUsed());
        transactionReceipt.put("logs", receiptDecoration.getLogs());
        transactionReceipt.put("blockNumber", receiptDecoration.getBlockNumber());
        data.put("transactionReceipt", transactionReceipt);
        mychainBaseResult.put("data", data);
        res.put("transaction", mychainBaseResult);
        if (receiptDecoration.getResult() == 0L) {
            return BaseResp.builder().success(true).code("200").data(JSON.toJSONString(res)).build();
        }
        return BaseResp.builder().success(true).code(Long.toString(receiptDecoration.getResult())).data(JSON.toJSONString(res)).build();
    }

    @Deprecated
    public BaseResp updateContractAsyncWithWholeReceipt(CallRestBizParam callRestBizParam) throws Exception {
        return this.bizChainCallWithWholeReceipt(callRestBizParam);
    }

    @Deprecated
    public BaseResp deployContractAsyncWithWholeReceipt(CallRestBizParam callRestBizParam) throws Exception {
        return this.bizChainCallWithWholeReceipt(callRestBizParam);
    }

    @Deprecated
    public BaseResp depositAsyncWithWholeReceipt(String txHash, String signData, String bizId) throws Exception {
        BaseResp depositResp = this.chainCall(txHash, bizId, signData, Method.DEPOSIT);
        if (!depositResp.isSuccess() || !depositResp.getCode().equals("200")) {
            return depositResp;
        }
        BaseResp baseResp = this.multipleQueryReceipt(bizId, txHash);
        return this.getRespByReceipt(baseResp, txHash);
    }

    @Deprecated
    public BaseResp callSolidityContractAsyncWithWholeReceipt(String txHash, String signData, String bizId) throws Exception {
        BaseResp callResp = this.chainCall(txHash, bizId, signData, Method.CALLCONTRACT);
        if (!callResp.isSuccess() || !callResp.getCode().equals("200")) {
            return callResp;
        }
        BaseResp baseResp = this.multipleQueryReceipt(bizId, txHash);
        return this.getRespByReceipt(baseResp, txHash);
    }

    @Deprecated
    public BaseResp callWasmContractAsyncWithWholeReceipt(CallRestBizParam callRestBizParam) throws Exception {
        return this.bizChainCallWithWholeReceipt(callRestBizParam);
    }

    @Deprecated
    public BaseResp callNativeContractAsyncWithReceipt(CallRestBizParam callRestBizParam) throws Exception {
        BaseResp callResp = this.chainCallForBiz(callRestBizParam);
        if (!callResp.isSuccess() || !callResp.getCode().equals("200")) {
            return callResp;
        }
        BaseResp baseResp = this.multipleQueryReceipt(callRestBizParam.getBizid(), callResp.getData());
        TransactionReceipt transactionReceipt = (TransactionReceipt)JSON.parseObject((String)baseResp.getData(), TransactionReceipt.class);
        return BaseResp.builder().success(true).code("200").data(JSON.toJSONString((Object)new String(transactionReceipt.getOutput()))).build();
    }

    public BaseResp chainCallWithReceipt(CallRestParam callRestParam) throws Exception {
        BaseResp callResp = this.chainCall(callRestParam);
        if (!callResp.isSuccess() || !callResp.getCode().equals("200")) {
            return callResp;
        }
        return this.multipleQueryReceipt(callRestParam.getBizid(), callResp.getData());
    }

    public BaseResp bizChainCallWithReceipt(CallRestBizParam callRestBizParam) throws Exception {
        BaseResp callResp = this.chainCallForBiz(callRestBizParam);
        if (!callResp.isSuccess() || !callResp.getCode().equals("200")) {
            return callResp;
        }
        return this.multipleQueryReceipt(callRestBizParam.getBizid(), callResp.getData());
    }

    private BaseResp bizChainCallWithWholeReceipt(CallRestBizParam callRestBizParam) throws Exception {
        BaseResp callResp = this.chainCallForBiz(callRestBizParam);
        if (!callResp.isSuccess() || !callResp.getCode().equals("200")) {
            return callResp;
        }
        String txHash = callResp.getData();
        BaseResp baseResp = this.multipleQueryReceipt(callRestBizParam.getBizid(), callResp.getData());
        return this.getRespByReceipt(baseResp, txHash);
    }

    public BaseResp createAccountByPublicKeyWithReceipt(CallRestParam callRestParam) throws Exception {
        BaseResp callResp = this.chainCall("", callRestParam.getBizid(), callRestParam.getRequestStr(), Method.CREATEACCOUNT);
        if (!callResp.isSuccess() || !callResp.getCode().equals("200")) {
            return callResp;
        }
        Thread.sleep(500L);
        BaseResp baseResp = this.multipleQueryReceipt(callRestParam.getBizid(), callResp.getData());
        if (!baseResp.isSuccess()) {
            TransactionReceipt transactionReceipt = (TransactionReceipt)JSON.parseObject((String)baseResp.getData(), TransactionReceipt.class);
            if (123L != transactionReceipt.getResult()) {
                throw new RuntimeException("queryreceipt errorCode:[" + baseResp.getCode() + "]");
            }
            Map request = (Map)JSON.parseObject((String)callRestParam.getRequestStr(), Map.class);
            ClientParam clientParam = this.createQueryAccountParam((String)request.get("baccount"));
            BaseResp accountResp = null;
            for (int retryTimes = 0; retryTimes < 5 && !(accountResp = this.chainCall(clientParam.getHash(), callRestParam.getBizid(), clientParam.getSignData(), Method.QUERYACCOUNT)).isSuccess(); ++retryTimes) {
            }
            if (!accountResp.isSuccess() || !"200".equals(accountResp.getCode())) {
                return accountResp;
            }
            Account account = new Account();
            account.fromJson(JSONObject.parseObject((String)accountResp.getData()));
            if (account.getRecoverKey().hexStrValue().equals(request.get("recoverKey"))) {
                return BaseResp.builder().success(true).code("200").data(callResp.getData()).build();
            }
            return BaseResp.builder().success(false).code("400").data("account already exists").build();
        }
        return baseResp;
    }

    public BaseResp callSolcContractAsyncWithReceipt(CallRestBizParam callRestBizParam) throws Exception {
        BaseResp callResp = this.chainCallForBiz(callRestBizParam);
        if (!callResp.isSuccess() || !callResp.getCode().equals("200")) {
            return callResp;
        }
        BaseResp baseResp = this.multipleQueryReceipt(callRestBizParam.getBizid(), callResp.getData());
        TransactionReceipt transactionReceipt = (TransactionReceipt)JSON.parseObject((String)baseResp.getData(), TransactionReceipt.class);
        List output = JSONArray.parseArray((String)callRestBizParam.getOutTypes(), String.class);
        List<Object> outRes = new ArrayList();
        if (output.size() > 0) {
            if (transactionReceipt.getOutput() == null && !((String)output.get(0)).equals(WasmParaType.VOID.getName())) {
                return BaseResp.builder().success(false).code("400").data("function has no any output!").build();
            }
            EVMOutput contractReturnValues = new EVMOutput(Hex.toHexString((byte[])transactionReceipt.getOutput()));
            outRes = ContractParameterUtils.getEVMOutput(contractReturnValues, output);
        }
        return BaseResp.builder().success(true).code("200").data(JSON.toJSONString(outRes)).build();
    }

    public BaseResp chainCallForBiz(final CallRestBizParam callRestBizParam) throws Exception {
        if (StringUtils.isEmpty((CharSequence)callRestBizParam.getTenantid()) && !StringUtils.isEmpty((CharSequence)this.restClientProperties.getTenantid())) {
            callRestBizParam.setTenantid(this.restClientProperties.getTenantid());
        }
        if (StringUtils.isEmpty((CharSequence)callRestBizParam.getBizid()) && !StringUtils.isEmpty((CharSequence)this.restClientProperties.getBizid())) {
            callRestBizParam.setBizid(this.restClientProperties.getBizid());
        }
        callRestBizParam.setAccessId(this.restClientProperties.getAccessId());
        callRestBizParam.setToken(this.restToken);
        BaseResp checkBaseResp = CheckBizParam.checkParams(callRestBizParam);
        if (!checkBaseResp.isSuccess()) {
            throw new RuntimeException(checkBaseResp.getData());
        }
        if ((Method.CREATEACCOUNT.equals((Object)callRestBizParam.getMethod()) || Method.DEPLOYNATIVECONTRACT.equals((Object)callRestBizParam.getMethod()) || Method.QUERYACCOUNT.equals((Object)callRestBizParam.getMethod())) && StringUtils.isEmpty((CharSequence)callRestBizParam.getMykmsKeyId())) {
            return this.chainCall("", callRestBizParam.getBizid(), callRestBizParam.getRequestStr(), callRestBizParam.getMethod());
        }
        final AtomicInteger retryTimes = new AtomicInteger(0);
        return (BaseResp)this.retryTemplate.execute((RetryCallback)new RetryCallback<Object, Exception>(){

            public Object doWithRetry(RetryContext context) throws Exception {
                BaseResp baseResp = RestClient.this.getHttpClient().callBaaSRest(RestClient.this.chainCallBizUrl, RestClient.CONTENT_TYPE, callRestBizParam, RestClient.this.restTemplate);
                if (!baseResp.isSuccess()) {
                    if (baseResp.getCode().equals("202")) {
                        RestClient.this.shake();
                        callRestBizParam.setToken(RestClient.this.restToken);
                    }
                    if ((baseResp.getCode().equals("202") || baseResp.getCode().startsWith("5")) && retryTimes.incrementAndGet() < RestClient.this.restClientProperties.getRetryMaxAttempts()) {
                        throw new RuntimeException("rest errorCode:[" + baseResp.getCode() + ",errMsg:" + baseResp.getData() + "]");
                    }
                }
                return baseResp;
            }
        });
    }

    public Long listenTopicsReliably(String eventId, List<String> topics, IEventCallback handler, VMTypeEnum vmTypeEnum, Boolean isPlainTopic) {
        return this.listenTopicsReliably(eventId, topics, handler, vmTypeEnum, isPlainTopic, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long listenTopicsReliably(String eventId, List<String> topics, IEventCallback handler, VMTypeEnum vmTypeEnum, Boolean isPlainTopic, int blockPullInterval) {
        Long taskId;
        RestClientReliableEventTask reliableEventTask = new RestClientReliableEventTask(eventId, this.restClientProperties.getBizid(), this, handler, topics, vmTypeEnum, isPlainTopic, this.restClientProperties.getListenInterval() * 4, blockPullInterval);
        RestClient restClient = this;
        synchronized (restClient) {
            if (timerTaskManager == null) {
                timerTaskManager = new TimerTaskManager();
                timerTaskManager.startTimerTask();
            }
            taskId = timerTaskManager.registerTask(reliableEventTask);
        }
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlistenTopicsReliably(Long taskId) {
        RestClient restClient = this;
        synchronized (restClient) {
            if (timerTaskManager != null) {
                timerTaskManager.unRegisterTask(taskId);
                return true;
            }
        }
        return false;
    }

    public BaseResp depositBigfile(String account, String endpoint, Iterator<Map.Entry<String, MultipartFile>> iter) throws Exception {
        while (iter.hasNext()) {
            String fileKey = UUID.randomUUID().toString();
            Map.Entry<String, MultipartFile> entry = iter.next();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(entry.getValue().getBytes());
            byte[] digest = messageDigest.digest();
            String fileSha256 = Hex.toHexString((byte[])digest);
            if (endpoint.equals("oss")) {
                this.ossUtil.upload2Oss(fileKey, new ByteArrayInputStream(entry.getValue().getBytes()));
            }
            ClientParam clientParam = this.createDepositTransaction(account, fileKey + ";" + fileSha256, 0L);
            BaseResp baseResp = this.chainCall(clientParam.getHash(), clientParam.getSignData(), Method.DEPOSIT);
            baseResp.setData(clientParam.getHash());
        }
        return BaseResp.builder().success(false).code("203").data("").build();
    }

    public BaseResp callCccsAdmin(final String uri, String tenantId) throws Exception {
        final CccsAdminRequest request = CccsAdminRequest.builder().cccsTenantId(tenantId).bizId(this.restClientProperties.getBizid()).accessId(this.restClientProperties.getAccessId()).token(this.restToken).build();
        final AtomicInteger retryTimes = new AtomicInteger(0);
        return (BaseResp)this.retryTemplate.execute((RetryCallback)new RetryCallback<Object, Exception>(){

            public Object doWithRetry(RetryContext context) throws Exception {
                String url = RestClient.this.restClientProperties.getRestUrl() + uri;
                BaseResp baseResp = RestClient.this.httpClient.callBaaSRest(url, RestClient.CONTENT_TYPE, request, RestClient.this.restTemplate);
                if (!baseResp.isSuccess()) {
                    if (baseResp.getCode().equals("202")) {
                        RestClient.this.shake();
                        request.setToken(RestClient.this.restToken);
                    }
                    if ((baseResp.getCode().equals("202") || baseResp.getCode().startsWith("5")) && retryTimes.incrementAndGet() < RestClient.this.restClientProperties.getRetryMaxAttempts()) {
                        throw new RuntimeException("rest errorCode:[" + baseResp.getCode() + ",errMsg:" + baseResp.getData() + "]");
                    }
                }
                return baseResp;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestHttpClient getHttpClient() {
        if (this.httpClient == null) {
            RestClient restClient = this;
            synchronized (restClient) {
                if (this.httpClient == null) {
                    System.out.println("create http client");
                    this.httpClient = new RestHttpClient();
                }
            }
        }
        return this.httpClient;
    }

    static {
        AESUtils.openAESLengthLimitation();
        logger = LoggerFactory.getLogger(RestClient.class);
    }
}

