/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient;

import com.antfinancial.mychain.baas.tool.restclient.RestClient;
import com.antfinancial.mychain.baas.tool.restclient.RestClientProperties;
import com.antfinancial.mychain.baas.tool.restclient.admin.impl.BaaSAdminClient;
import com.antfinancial.mychain.baas.tool.restclient.client.RestHttpClient;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={RestClientProperties.class})
public class RestClientConfiguration {
    @Autowired
    private RestClientProperties restClientProperties;

    @Bean
    @ConditionalOnMissingBean
    public RestClient getRestClient() throws IOException {
        int connectionRequestTimeout = this.restClientProperties.getConnectionRequestTimeout() != 0 ? this.restClientProperties.getConnectionRequestTimeout() : 3000;
        int connectTimeout = this.restClientProperties.getConnectTimeout() != 0 ? this.restClientProperties.getConnectTimeout() : 3000;
        int socketTimeout = this.restClientProperties.getSocketTimeout() != 0 ? this.restClientProperties.getSocketTimeout() : 2000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        int maxTotal = this.restClientProperties.getMaxTotal() != 0 ? this.restClientProperties.getMaxTotal() : 200;
        int maxPerRoute = this.restClientProperties.getDefaultMaxPerRoute() != 0 ? this.restClientProperties.getDefaultMaxPerRoute() : 200;
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(maxTotal);
        connectionManager.setDefaultMaxPerRoute(maxPerRoute);
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)client);
        factory.setReadTimeout(15000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        restTemplate.getMessageConverters().add(new CustomizeHttpMessageConverter());
        return new RestClient(restTemplate, this.restClientProperties);
    }

    @Bean
    public RetryTemplate retryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        fixedBackOffPolicy.setBackOffPeriod(this.restClientProperties.getBackOffPeriod() != 0 ? (long)this.restClientProperties.getBackOffPeriod() : 500L);
        retryTemplate.setBackOffPolicy((BackOffPolicy)fixedBackOffPolicy);
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
        retryPolicy.setMaxAttempts(this.restClientProperties.getRetryMaxAttempts() != 0 ? this.restClientProperties.getRetryMaxAttempts() : 5);
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        return retryTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public RestHttpClient restHttpClient() {
        return new RestHttpClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public BaaSAdminClient baasAdminClient() {
        return new BaaSAdminClient();
    }

    private String readFromInputStream(InputStream inputStream) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] buf = new byte[2048];
        int length = 0;
        while ((length = inputStream.read(buf)) >= 0) {
            stringBuilder.append(new String(buf, 0, length));
        }
        return stringBuilder.toString();
    }

    public class CustomizeHttpMessageConverter
    extends MappingJackson2HttpMessageConverter {
        public CustomizeHttpMessageConverter() {
            ArrayList mediaTypes = Lists.newArrayList();
            mediaTypes.add(MediaType.TEXT_XML);
            mediaTypes.add(MediaType.TEXT_PLAIN);
            mediaTypes.add(MediaType.TEXT_HTML);
            mediaTypes.add(MediaType.APPLICATION_JSON);
            this.setSupportedMediaTypes(mediaTypes);
        }
    }
}

