/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient.request;

import com.alibaba.fastjson.JSON;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.message.transaction.contract.DeployContractRequest;
import com.alipay.mychain.sdk.vm.EVMParameter;
import com.antfinancial.mychain.baas.tool.restclient.model.ClientParam;
import com.antfinancial.mychain.baas.tool.restclient.model.DeployContractWithSignature;
import com.antfinancial.mychain.baas.tool.restclient.request.ConstructAbstractRequest;
import com.antfinancial.mychain.baas.tool.restclient.utils.MytfSdkAdaptUtil;
import java.math.BigInteger;
import java.util.List;

public class ConstructDeployContractRequest
extends ConstructAbstractRequest {
    public ClientParam createDeployContractTransaction(Identity account, Identity contractName, byte[] code, VMTypeEnum vmTypeEnum, Long gas, List<SignerBase> signerBases, String secretKey) {
        EVMParameter evmParameter = new EVMParameter();
        DeployContractRequest request = new DeployContractRequest(account, contractName, code, vmTypeEnum, evmParameter, BigInteger.ZERO);
        MytfSdkAdaptUtil.setTxGas(request, gas);
        this.completeRequest(request);
        Transaction transaction = request.getTransaction();
        transaction.calcSignature(signerBases);
        DeployContractWithSignature deployContractWithSignature = new DeployContractWithSignature();
        deployContractWithSignature.setDeployContractRaw(request.toRlp());
        deployContractWithSignature.setHash(transaction.getHash().hexStrValue());
        deployContractWithSignature.setTimestamp(transaction.getTimestamp());
        deployContractWithSignature.setVmTypeEnum(vmTypeEnum);
        deployContractWithSignature.setSecretKey(secretKey);
        ClientParam clientParam = new ClientParam();
        clientParam.setHash(transaction.getHash().hexStrValue());
        clientParam.setSignData(JSON.toJSONString((Object)deployContractWithSignature));
        return clientParam;
    }

    public ClientParam createEncryptDeployContractTransaction(Identity account, Identity contractName, byte[] code, VMTypeEnum vmTypeEnum, Long gas, List<SignerBase> signerBases, String teePublicKey, String secretKey) {
        EVMParameter evmParameter = new EVMParameter();
        DeployContractRequest request = new DeployContractRequest(account, contractName, code, vmTypeEnum, evmParameter, BigInteger.ZERO);
        MytfSdkAdaptUtil.setTxGas(request, gas);
        this.completeRequest(request);
        Transaction transaction = request.getTransaction();
        transaction.calcSignature(signerBases);
        DeployContractWithSignature deployContractWithSignature = new DeployContractWithSignature();
        deployContractWithSignature.setDeployContractRaw(request.toRlp());
        deployContractWithSignature.setHash(transaction.getHash().hexStrValue());
        deployContractWithSignature.setTimestamp(transaction.getTimestamp());
        deployContractWithSignature.setVmTypeEnum(vmTypeEnum);
        ClientParam clientParam = new ClientParam();
        clientParam.setHash(transaction.getHash().hexStrValue());
        clientParam.setSignData(JSON.toJSONString((Object)deployContractWithSignature));
        return clientParam;
    }
}

